/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder;

import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2680;
import net.minecraft.class_4158;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;

@Mixin(class_4158.class)
public interface PointOfInterestTypeAccessor {
	@Invoker("<init>")
	static class_4158 callCreate(String id, Set<class_2680> blockStates, int ticketCount, Predicate<class_4158> typePredicate, int searchDistance) {
		throw new AssertionError("Untransformed Accessor!");
	}

	@Invoker("<init>")
	static class_4158 callCreate(String id, Set<class_2680> blockStates, int ticketCount, int searchDistance) {
		throw new AssertionError("Untransformed Accessor!");
	}

	@Invoker("setup")
	static class_4158 callSetup(class_4158 pointOfInterestType) {
		throw new AssertionError("Untransformed Accessor!");
	}
}
