/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.object.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.fabricmc.fabric.mixin.object.builder.TrackedDataHandlerRegistryAccessor;
import net.minecraft.class_2378;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_3513;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricTrackedDataRegistryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricTrackedDataRegistryImpl.class);
    private static final class_2960 HANDLER_REGISTRY_ID = class_2960.method_60655((String)"fabric-object-builder-api-v1", (String)"tracked_data_handler");
    private static final class_5321<class_2378<class_2941<?>>> HANDLER_REGISTRY_KEY = class_5321.method_29180((class_2960)HANDLER_REGISTRY_ID);
    private static final List<class_2941<?>> VANILLA_HANDLERS = new ArrayList();
    @Nullable
    private static class_2378<class_2941<?>> handlerRegistry = null;
    private static final List<class_2941<?>> EXTERNAL_MODDED_HANDLERS = new ArrayList();

    private FabricTrackedDataRegistryImpl() {
    }

    public static boolean hasStoredVanillaHandlers() {
        return !VANILLA_HANDLERS.isEmpty();
    }

    public static void storeVanillaHandlers() {
        if (FabricTrackedDataRegistryImpl.hasStoredVanillaHandlers()) {
            throw new IllegalStateException("Already stored vanilla handlers!");
        }
        class_3513<class_2941<?>> dataHandlers = TrackedDataHandlerRegistryAccessor.fabric_getDataHandlers();
        for (class_2941 handler : dataHandlers) {
            VANILLA_HANDLERS.add(handler);
        }
        LOGGER.debug("Stored {} vanilla handlers", (Object)VANILLA_HANDLERS.size());
    }

    private static void storeExternalHandlers() {
        class_3513<class_2941<?>> dataHandlers = TrackedDataHandlerRegistryAccessor.fabric_getDataHandlers();
        for (class_2941 handler : dataHandlers) {
            if (VANILLA_HANDLERS.contains(handler) || handlerRegistry != null && handlerRegistry.method_10221((Object)handler) != null || EXTERNAL_MODDED_HANDLERS.contains(handler)) continue;
            EXTERNAL_MODDED_HANDLERS.add(handler);
            LOGGER.warn("Tracked data handler {} is not managed by vanilla or Fabric API; it may be prone to desynchronization!", (Object)handler);
        }
    }

    private static void reorderHandlers() {
        class_3513<class_2941<?>> dataHandlers = TrackedDataHandlerRegistryAccessor.fabric_getDataHandlers();
        LOGGER.debug("Reordering tracked data handlers containing {} entries", (Object)dataHandlers.method_10204());
        dataHandlers.method_15229();
        for (class_2941<?> handler : VANILLA_HANDLERS) {
            dataHandlers.method_15225(handler);
        }
        if (handlerRegistry != null) {
            for (class_2941<?> handler : handlerRegistry) {
                dataHandlers.method_15225(handler);
            }
        }
        for (class_2941<?> handler : EXTERNAL_MODDED_HANDLERS) {
            dataHandlers.method_15225(handler);
        }
        LOGGER.debug("Finished reordering tracked data handlers containing {} entries", (Object)dataHandlers.method_10204());
    }

    public static void register(class_2960 id, class_2941<?> handler) {
        Objects.requireNonNull(id, "Tracked data handler ID cannot be null!");
        Objects.requireNonNull(handler, "Tracked data handler cannot be null!");
        FabricTrackedDataRegistryImpl.storeExternalHandlers();
        if (VANILLA_HANDLERS.contains(handler) || EXTERNAL_MODDED_HANDLERS.contains(handler)) {
            throw new IllegalArgumentException("Cannot register tracked data handler previously added via TrackedDataHandlerRegistry.register");
        }
        if (handlerRegistry == null) {
            handlerRegistry = FabricRegistryBuilder.createSimple(HANDLER_REGISTRY_KEY).attribute(RegistryAttribute.SYNCED).buildAndRegister();
            RegistryIdRemapCallback.event(handlerRegistry).register(state -> {
                FabricTrackedDataRegistryImpl.storeExternalHandlers();
                FabricTrackedDataRegistryImpl.reorderHandlers();
            });
        }
        class_2378.method_10230(handlerRegistry, (class_2960)id, handler);
        FabricTrackedDataRegistryImpl.reorderHandlers();
    }

    @Nullable
    public static class_2941<?> get(class_2960 id) {
        Objects.requireNonNull(id, "Tracked data handler ID cannot be null!");
        if (handlerRegistry == null) {
            return null;
        }
        return (class_2941)handlerRegistry.method_63535(id);
    }

    @Nullable
    public static class_2960 getId(class_2941<?> handler) {
        Objects.requireNonNull(handler, "Tracked data handler cannot be null!");
        if (handlerRegistry == null) {
            return null;
        }
        return handlerRegistry.method_10221(handler);
    }
}

