/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder;

import java.util.Objects;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityType;
import net.fabricmc.fabric.impl.object.builder.FabricEntityTypeImpl;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

@Mixin(class_1299.class_1300.class)
public abstract class EntityTypeBuilderMixin<T extends class_1297> implements FabricEntityType.Builder<T>, FabricEntityTypeImpl.Builder {
	@Shadow
	public abstract class_1299<T> build(class_5321<class_1299<?>> registryKey);

	@Unique
	@Nullable
	private Boolean alwaysUpdateVelocity = null;
	@Unique
	@Nullable
	private Boolean canPotentiallyExecuteCommands = null;

	@Unique
	private FabricEntityTypeImpl.Builder.Living<? extends class_1309> livingBuilder = null;
	@Unique
	private FabricEntityTypeImpl.Builder.Mob<? extends net.minecraft.class_1308> mobBuilder = null;

	@Override
	public class_1299.class_1300<T> alwaysUpdateVelocity(boolean alwaysUpdateVelocity) {
		this.alwaysUpdateVelocity = alwaysUpdateVelocity;
		return (class_1299.class_1300<T>) (Object) this;
	}

	@Override
	public class_1299.class_1300<T> canPotentiallyExecuteCommands(boolean canPotentiallyExecuteCommands) {
		this.canPotentiallyExecuteCommands = canPotentiallyExecuteCommands;
		return (class_1299.class_1300<T>) (Object) this;
	}

	@Inject(method = "build", at = @At("RETURN"))
	private void applyChildBuilders(class_5321<class_1299<?>> registryKey, CallbackInfoReturnable<class_1299<T>> cir) {
		if (!(cir.getReturnValue() instanceof FabricEntityTypeImpl entityType)) {
			throw new IllegalStateException();
		}

		entityType.fabric_setAlwaysUpdateVelocity(alwaysUpdateVelocity);
		entityType.fabric_setCanPotentiallyExecuteCommands(canPotentiallyExecuteCommands);

		if (livingBuilder != null) {
			livingBuilder.onBuild(castLiving(cir.getReturnValue()));
		}

		if (mobBuilder != null) {
			mobBuilder.onBuild(castMob(cir.getReturnValue()));
		}
	}

	@SuppressWarnings("unchecked")
	@Unique
	private static <T extends class_1309> class_1299<T> castLiving(class_1299<?> type) {
		return (class_1299<T>) type;
	}

	@SuppressWarnings("unchecked")
	@Unique
	private static <T extends net.minecraft.class_1308> class_1299<T> castMob(class_1299<?> type) {
		return (class_1299<T>) type;
	}

	@WrapOperation(method = "build", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/Util;fetchChoiceType(Lcom/mojang/datafixers/DSL$TypeReference;Ljava/lang/String;)Lcom/mojang/datafixers/types/Type;"))
	private @Nullable Type<?> allowNoModdedDatafixers(DSL.TypeReference typeReference, String id, Operation<Type<?>> original, @Local(argsOnly = true) class_5321<class_1299<?>> registryKey) {
		if (!registryKey.method_29177().method_12836().equals(class_2960.field_33381)) {
			// Don't try to resolve the choice type for modded entities.
			return null;
		}

		return original.call(typeReference, id);
	}

	@Override
	public void fabric_setLivingEntityBuilder(FabricEntityTypeImpl.Builder.Living<? extends class_1309> livingBuilder) {
		Objects.requireNonNull(livingBuilder, "Cannot set null living entity builder");
		this.livingBuilder = livingBuilder;
	}

	@Override
	public void fabric_setMobEntityBuilder(FabricEntityTypeImpl.Builder.Mob<? extends net.minecraft.class_1308> mobBuilder) {
		Objects.requireNonNull(mobBuilder, "Cannot set null mob entity builder");
		this.mobBuilder = mobBuilder;
	}
}
