/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.trade;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.impl.object.builder.TradeOfferInternals;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import org.jetbrains.annotations.ApiStatus;

public final class TradeOfferHelper {
    public static void registerVillagerOffers(ResourceKey<VillagerProfession> profession, int level, Consumer<List<VillagerTrades.ItemListing>> factories) {
        TradeOfferInternals.registerVillagerOffers(profession, level, (List<VillagerTrades.ItemListing> trades, boolean rebalanced) -> factories.accept(trades));
    }

    @ApiStatus.Experimental
    public static void registerVillagerOffers(ResourceKey<VillagerProfession> profession, int level, VillagerOffersAdder factories) {
        TradeOfferInternals.registerVillagerOffers(profession, level, factories);
    }

    public static synchronized void registerWanderingTraderOffers(Consumer<WanderingTraderOffersBuilder> factory) {
        factory.accept(new TradeOfferInternals.WanderingTraderOffersBuilderImpl());
    }

    private TradeOfferHelper() {
    }

    @FunctionalInterface
    public static interface VillagerOffersAdder {
        public void onRegister(List<VillagerTrades.ItemListing> var1, boolean var2);
    }

    @ApiStatus.NonExtendable
    public static interface WanderingTraderOffersBuilder {
        public static final Identifier BUY_ITEMS_POOL = Identifier.withDefaultNamespace((String)"buy_items");
        public static final Identifier SELL_SPECIAL_ITEMS_POOL = Identifier.withDefaultNamespace((String)"sell_special_items");
        public static final Identifier SELL_COMMON_ITEMS_POOL = Identifier.withDefaultNamespace((String)"sell_common_items");

        public WanderingTraderOffersBuilder pool(Identifier var1, int var2, VillagerTrades.ItemListing ... var3);

        default public WanderingTraderOffersBuilder pool(Identifier id, int count, Collection<? extends VillagerTrades.ItemListing> factories) {
            return this.pool(id, count, (VillagerTrades.ItemListing[])factories.toArray(VillagerTrades.ItemListing[]::new));
        }

        default public WanderingTraderOffersBuilder addAll(Identifier id, Collection<? extends VillagerTrades.ItemListing> factories) {
            return this.pool(id, factories.size(), factories);
        }

        default public WanderingTraderOffersBuilder addAll(Identifier id, VillagerTrades.ItemListing ... factories) {
            return this.pool(id, factories.length, factories);
        }

        public WanderingTraderOffersBuilder addOffersToPool(Identifier var1, VillagerTrades.ItemListing ... var2);

        default public WanderingTraderOffersBuilder addOffersToPool(Identifier pool, Collection<VillagerTrades.ItemListing> factories) {
            return this.addOffersToPool(pool, (VillagerTrades.ItemListing[])factories.toArray(VillagerTrades.ItemListing[]::new));
        }
    }
}

