/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.object.builder;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Util;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class TradeOfferInternals {
    private TradeOfferInternals() {
    }

    private static void initVillagerTrades() {
        if (!(VillagerTrades.EXPERIMENTAL_TRADES instanceof HashMap)) {
            HashMap<ResourceKey, Int2ObjectMap> map = new HashMap<ResourceKey, Int2ObjectMap>(VillagerTrades.EXPERIMENTAL_TRADES);
            for (Map.Entry trade : VillagerTrades.TRADES.entrySet()) {
                if (map.containsKey(trade.getKey())) continue;
                map.put((ResourceKey)trade.getKey(), (Int2ObjectMap)trade.getValue());
            }
            VillagerTrades.EXPERIMENTAL_TRADES = map;
        }
    }

    public static synchronized void registerVillagerOffers(ResourceKey<VillagerProfession> profession, int level, TradeOfferHelper.VillagerOffersAdder factory) {
        Objects.requireNonNull(profession, "VillagerProfession may not be null.");
        TradeOfferInternals.initVillagerTrades();
        TradeOfferInternals.registerOffers((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.TRADES.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap()), level, trades -> factory.onRegister((List<VillagerTrades.ItemListing>)trades, false));
        TradeOfferInternals.registerOffers((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.EXPERIMENTAL_TRADES.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap()), level, trades -> factory.onRegister((List<VillagerTrades.ItemListing>)trades, true));
    }

    private static void registerOffers(Int2ObjectMap<VillagerTrades.ItemListing[]> leveledTradeMap, int level, Consumer<List<VillagerTrades.ItemListing>> factory) {
        ArrayList list = new ArrayList();
        factory.accept(list);
        Object[] originalEntries = (VillagerTrades.ItemListing[])leveledTradeMap.computeIfAbsent(level, key -> new VillagerTrades.ItemListing[0]);
        Object[] addedEntries = list.toArray(new VillagerTrades.ItemListing[0]);
        VillagerTrades.ItemListing[] allEntries = (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])originalEntries, (Object[])addedEntries);
        leveledTradeMap.put(level, (Object)allEntries);
    }

    public static class WanderingTraderOffersBuilderImpl
    implements TradeOfferHelper.WanderingTraderOffersBuilder {
        private static final Object2IntMap<Identifier> ID_TO_INDEX = (Object2IntMap)Util.make((Object)new Object2IntOpenHashMap(), idToIndex -> {
            idToIndex.put((Object)BUY_ITEMS_POOL, 0);
            idToIndex.put((Object)SELL_SPECIAL_ITEMS_POOL, 1);
            idToIndex.put((Object)SELL_COMMON_ITEMS_POOL, 2);
        });
        private static final Map<Identifier, VillagerTrades.ItemListing[]> DELAYED_MODIFICATIONS = new HashMap<Identifier, VillagerTrades.ItemListing[]>();

        static void initWanderingTraderTrades() {
            if (!(VillagerTrades.WANDERING_TRADER_TRADES instanceof ArrayList)) {
                VillagerTrades.WANDERING_TRADER_TRADES = new ArrayList(VillagerTrades.WANDERING_TRADER_TRADES);
            }
        }

        @Override
        public TradeOfferHelper.WanderingTraderOffersBuilder pool(Identifier id, int count, VillagerTrades.ItemListing ... factories) {
            if (factories.length == 0) {
                throw new IllegalArgumentException("cannot add empty pool");
            }
            if (count <= 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            Objects.requireNonNull(id, "id cannot be null");
            if (ID_TO_INDEX.containsKey((Object)id)) {
                throw new IllegalArgumentException("pool id %s is already registered".formatted(id));
            }
            Pair pool = Pair.of((Object)factories, (Object)count);
            WanderingTraderOffersBuilderImpl.initWanderingTraderTrades();
            ID_TO_INDEX.put((Object)id, VillagerTrades.WANDERING_TRADER_TRADES.size());
            VillagerTrades.WANDERING_TRADER_TRADES.add(pool);
            VillagerTrades.ItemListing[] delayedModifications = DELAYED_MODIFICATIONS.remove(id);
            if (delayedModifications != null) {
                this.addOffersToPool(id, delayedModifications);
            }
            return this;
        }

        @Override
        public TradeOfferHelper.WanderingTraderOffersBuilder addOffersToPool(Identifier pool, VillagerTrades.ItemListing ... factories) {
            if (!ID_TO_INDEX.containsKey((Object)pool)) {
                DELAYED_MODIFICATIONS.compute(pool, (id, current) -> {
                    if (current == null) {
                        return factories;
                    }
                    return (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])current, (Object[])factories);
                });
                return this;
            }
            int poolIndex = ID_TO_INDEX.getInt((Object)pool);
            WanderingTraderOffersBuilderImpl.initWanderingTraderTrades();
            Pair poolPair = (Pair)VillagerTrades.WANDERING_TRADER_TRADES.get(poolIndex);
            VillagerTrades.ItemListing[] modified = (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])((VillagerTrades.ItemListing[])poolPair.getLeft()), (Object[])factories);
            VillagerTrades.WANDERING_TRADER_TRADES.set(poolIndex, Pair.of((Object)modified, (Object)((Integer)poolPair.getRight())));
            return this;
        }
    }
}

