/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.entity;

import net.fabricmc.fabric.impl.entity.FabricEntityType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1937;
import net.minecraft.class_4048;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.function.Function;

/**
 * Extended version of {@link EntityType.Builder} with added registration for
 * server->client entity tracking values.
 *
 * @param <T> Entity class.
 */
// TODO more javadocs
public class FabricEntityTypeBuilder<T extends class_1297> {
	private static final Logger LOGGER = LogManager.getLogger();
	private final class_1311 category;
	private final class_1299.class_4049<T> function;
	private boolean saveable = true;
	private boolean summonable = true;
	private int trackingDistance = -1;
	private int updateIntervalTicks = -1;
	private Boolean alwaysUpdateVelocity;
	private boolean immuneToFire = false;
	private class_4048 size = class_4048.method_18384(-1.0f, -1.0f);

	protected FabricEntityTypeBuilder(class_1311 category, class_1299.class_4049<T> function) {
		this.category = category;
		this.function = function;
	}

	public static <T extends class_1297> FabricEntityTypeBuilder<T> create(class_1311 category) {
		return new FabricEntityTypeBuilder<>(category, (t, w) -> null);
	}

	/**
	 * @deprecated Use {@link FabricEntityTypeBuilder#create(EntityCategory, EntityType.EntityFactory)}
	 */
	@Deprecated
	public static <T extends class_1297> FabricEntityTypeBuilder<T> create(class_1311 category, Function<? super class_1937, ? extends T> function) {
		return create(category, (t, w) -> function.apply(w));
	}

	public static <T extends class_1297> FabricEntityTypeBuilder<T> create(class_1311 category, class_1299.class_4049<T> function) {
		return new FabricEntityTypeBuilder<>(category, function);
	}

	public FabricEntityTypeBuilder<T> disableSummon() {
		this.summonable = false;
		return this;
	}

	public FabricEntityTypeBuilder<T> disableSaving() {
		this.saveable = false;
		return this;
	}

	public FabricEntityTypeBuilder<T> setImmuneToFire() {
		this.immuneToFire = true;
		return this;
	}

	/**
	 * @deprecated Use {@link FabricEntityTypeBuilder#size(EntityDimensions)}
	 */
	@Deprecated
	public FabricEntityTypeBuilder<T> size(float width, float height) {
		this.size = class_4048.method_18384(width, height);
		return this;
	}

	public FabricEntityTypeBuilder<T> size(class_4048 size) {
		this.size = size;
		return this;
	}

	public FabricEntityTypeBuilder<T> trackable(int trackingDistanceBlocks, int updateIntervalTicks) {
		return trackable(trackingDistanceBlocks, updateIntervalTicks, true);
	}

	public FabricEntityTypeBuilder<T> trackable(int trackingDistanceBlocks, int updateIntervalTicks, boolean alwaysUpdateVelocity) {
		this.trackingDistance = trackingDistanceBlocks;
		this.updateIntervalTicks = updateIntervalTicks;
		this.alwaysUpdateVelocity = alwaysUpdateVelocity;
		return this;
	}

	public class_1299<T> build() {
		if (this.saveable) {
			// SNIP! Modded datafixers are not supported anyway.
			// TODO: Flesh out once modded datafixers exist.
		}

		boolean figureMeOut1 = this.category == class_1311.field_6294 || this.category == class_1311.field_17715; // TODO
		class_1299<T> type = new FabricEntityType<T>(this.function, this.category, this.saveable, this.summonable, this.immuneToFire, figureMeOut1, size, trackingDistance, updateIntervalTicks, alwaysUpdateVelocity);

		return type;
	}
}
