/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.builders;

import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

@Mixin(class_2248.class_2251.class)
public interface BlockSettingsHooks {
    @Accessor
    void setHardness(float hardness);

    @Accessor
    void setResistance(float resistance);

    @Accessor
    void setCollidable(boolean collidable);

    @Accessor
    void setMaterialColor(class_3620 materialColor);

    @Accessor
    void setDropTableId(class_2960 dropTableId);

    @Invoker
    class_2248.class_2251 invokeSounds(class_2498 group);

    @Invoker
    class_2248.class_2251 invokeLightLevel(int lightLevel);

    @Invoker
    class_2248.class_2251 invokeBreakInstantly();

    @Invoker
    class_2248.class_2251 invokeStrength(float strength);

    @Invoker
    class_2248.class_2251 invokeTicksRandomly();

    @Invoker
    class_2248.class_2251 invokeHasDynamicBounds();

    @Invoker
    class_2248.class_2251 invokeDropsNothing();
}
