/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.block.BlockSettingsExtensions;
import net.fabricmc.fabric.api.event.registry.BlockConstructedCallback;
import net.fabricmc.fabric.impl.tools.ToolManager;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3620;

public class FabricBlockSettings {
    private static final Map<class_2248.class_2251, ExtraData> EXTRA_DATA;
    protected final class_2248.class_2251 delegate;

    static ExtraData computeExtraData(class_2248.class_2251 settings) {
        return EXTRA_DATA.computeIfAbsent(settings, x$0 -> new ExtraData((class_2248.class_2251)x$0));
    }

    private static void onBuild(class_2248.class_2251 settings, class_2248 block) {
        ExtraData data = EXTRA_DATA.get(settings);
        if (data != null) {
            if (data.breakByHand != null) {
                ToolManager.entry((class_2248)block).setBreakByHand(data.breakByHand.booleanValue());
            }
            for (MiningLevel tml : data.miningLevels) {
                ToolManager.entry((class_2248)block).putBreakByTool(tml.tag, tml.level);
            }
        }
    }

    protected FabricBlockSettings(class_3614 material, class_3620 color) {
        this(class_2248.class_2251.method_9639((class_3614)material, (class_3620)color));
    }

    protected FabricBlockSettings(class_2248 base) {
        this(class_2248.class_2251.method_9630((class_2248)base));
    }

    protected FabricBlockSettings(class_2248.class_2251 delegate) {
        this.delegate = delegate;
    }

    public static FabricBlockSettings of(class_3614 material) {
        return FabricBlockSettings.of(material, material.method_15803());
    }

    public static FabricBlockSettings of(class_3614 material, class_3620 color) {
        return new FabricBlockSettings(material, color);
    }

    public static FabricBlockSettings of(class_3614 material, class_1767 color) {
        return new FabricBlockSettings(material, color.method_7794());
    }

    public static FabricBlockSettings copy(class_2248 base) {
        return new FabricBlockSettings(base);
    }

    public static FabricBlockSettings copyOf(class_2248.class_2251 settings) {
        return new FabricBlockSettings(settings);
    }

    public FabricBlockSettings breakByHand(boolean breakByHand) {
        FabricBlockSettings.computeExtraData(this.delegate).breakByHand(breakByHand);
        return this;
    }

    public FabricBlockSettings breakByTool(class_3494<class_1792> tag, int miningLevel) {
        FabricBlockSettings.computeExtraData(this.delegate).addMiningLevel(tag, miningLevel);
        return this;
    }

    public FabricBlockSettings breakByTool(class_3494<class_1792> tag) {
        return this.breakByTool(tag, 0);
    }

    public FabricBlockSettings materialColor(class_3620 color) {
        BlockSettingsExtensions.materialColor(this.delegate, color);
        return this;
    }

    public FabricBlockSettings materialColor(class_1767 color) {
        return this.materialColor(color.method_7794());
    }

    public FabricBlockSettings collidable(boolean collidable) {
        BlockSettingsExtensions.collidable(this.delegate, collidable);
        return this;
    }

    public FabricBlockSettings noCollision() {
        this.delegate.method_9634();
        return this;
    }

    public FabricBlockSettings sounds(class_2498 group) {
        BlockSettingsExtensions.sounds(this.delegate, group);
        return this;
    }

    public FabricBlockSettings ticksRandomly() {
        BlockSettingsExtensions.ticksRandomly(this.delegate);
        return this;
    }

    public FabricBlockSettings lightLevel(int lightLevel) {
        BlockSettingsExtensions.lightLevel(this.delegate, lightLevel);
        return this;
    }

    public FabricBlockSettings hardness(float hardness) {
        BlockSettingsExtensions.hardness(this.delegate, hardness);
        return this;
    }

    public FabricBlockSettings resistance(float resistance) {
        BlockSettingsExtensions.resistance(this.delegate, resistance);
        return this;
    }

    public FabricBlockSettings strength(float hardness, float resistance) {
        this.delegate.method_9629(hardness, resistance);
        return this;
    }

    public FabricBlockSettings breakInstantly() {
        BlockSettingsExtensions.breakInstantly(this.delegate);
        return this;
    }

    public FabricBlockSettings dropsNothing() {
        BlockSettingsExtensions.dropsNothing(this.delegate);
        return this;
    }

    public FabricBlockSettings dropsLike(class_2248 block) {
        this.delegate.method_16228(block);
        return this;
    }

    public FabricBlockSettings drops(class_2960 dropTableId) {
        BlockSettingsExtensions.drops(this.delegate, dropTableId);
        return this;
    }

    @Deprecated
    public FabricBlockSettings friction(float friction) {
        this.delegate.method_9628(friction);
        return this;
    }

    public FabricBlockSettings slipperiness(float value) {
        this.delegate.method_9628(value);
        return this;
    }

    public FabricBlockSettings dynamicBounds() {
        BlockSettingsExtensions.dynamicBounds(this.delegate);
        return this;
    }

    public class_2248.class_2251 build() {
        return this.delegate;
    }

    public <T> T build(Function<class_2248.class_2251, T> function) {
        return function.apply(this.delegate);
    }

    static {
        BlockConstructedCallback.EVENT.register(FabricBlockSettings::onBuild);
        EXTRA_DATA = new HashMap<class_2248.class_2251, ExtraData>();
    }

    private static final class MiningLevel {
        private final class_3494<class_1792> tag;
        private final int level;

        MiningLevel(class_3494<class_1792> tag, int level) {
            this.tag = tag;
            this.level = level;
        }
    }

    static final class ExtraData {
        private final List<MiningLevel> miningLevels = new ArrayList<MiningLevel>();
        private Boolean breakByHand;

        private ExtraData(class_2248.class_2251 settings) {
        }

        void breakByHand(boolean breakByHand) {
            this.breakByHand = breakByHand;
        }

        void addMiningLevel(class_3494<class_1792> tag, int level) {
            this.miningLevels.add(new MiningLevel(tag, level));
        }
    }
}

