/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder;

import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

@Mixin(class_4970.class_2251.class)
public interface BlockSettingsHooks {
	@Accessor
	void setHardness(float hardness);

	@Accessor
	void setResistance(float resistance);

	@Accessor
	void setCollidable(boolean collidable);

	@Accessor
	void setMaterialColor(Function<class_2680, class_3620> materialColorFunction);

	@Accessor
	void setDropTableId(class_2960 dropTableId);

	@Invoker
	class_2248.Settings invokeSounds(class_2498 group);

	@Invoker
	class_2248.Settings invokeLightLevel(ToIntFunction<class_2680> lightLevelFunction);

	@Invoker
	class_2248.Settings invokeBreakInstantly();

	@Invoker
	class_2248.Settings invokeStrength(float strength);

	@Invoker
	class_2248.Settings invokeTicksRandomly();

	@Invoker
	class_2248.Settings invokeHasDynamicBounds();

	@Invoker
	class_2248.Settings invokeDropsNothing();
}
