/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.block;

import net.fabricmc.fabric.impl.object.builder.FabricBlockInternals;
import net.fabricmc.fabric.mixin.object.builder.BlockSettingsAccessor;
import net.minecraft.class_1792;
import net.minecraft.class_2248.class_2251;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3620;

/**
 * @deprecated Please migrate to v1. Please use methods in {@link net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings} instead.
 */
@Deprecated
public final class BlockSettingsExtensions {
	private BlockSettingsExtensions() {
	}

	public static void breakByHand(class_2251 settings, boolean breakByHand) {
		FabricBlockInternals.computeExtraData(settings).breakByHand(breakByHand);
	}

	public static void breakByTool(class_2251 settings, class_3494<class_1792> tag, int miningLevel) {
		FabricBlockInternals.computeExtraData(settings).addMiningLevel(tag, miningLevel);
	}

	public static void hardness(class_2251 settings, float hardness) {
		((BlockSettingsAccessor) settings).setHardness(hardness);
	}

	public static void resistance(class_2251 settings, float resistance) {
		((BlockSettingsAccessor) settings).setResistance(Math.max(0.0F, resistance));
	}

	public static void collidable(class_2251 settings, boolean collidable) {
		((BlockSettingsAccessor) settings).setCollidable(collidable);
	}

	public static void materialColor(class_2251 settings, class_3620 materialColor) {
		((BlockSettingsAccessor) settings).setMaterialColor(materialColor);
	}

	public static void drops(class_2251 settings, class_2960 dropTableId) {
		((BlockSettingsAccessor) settings).setDropTableId(dropTableId);
	}

	public static void sounds(class_2251 settings, class_2498 soundGroup) {
		((BlockSettingsAccessor) settings).invokeSounds(soundGroup);
	}

	public static void lightLevel(class_2251 settings, int lightLevel) {
		((BlockSettingsAccessor) settings).invokeLightLevel(lightLevel);
	}

	public static void breakInstantly(class_2251 settings) {
		((BlockSettingsAccessor) settings).invokeBreakInstantly();
	}

	public static void strength(class_2251 settings, float strength) {
		((BlockSettingsAccessor) settings).invokeStrength(strength);
	}

	public static void ticksRandomly(class_2251 settings) {
		((BlockSettingsAccessor) settings).invokeTicksRandomly();
	}

	public static void dynamicBounds(class_2251 settings) {
		// Thanks Mixin
		((BlockSettingsAccessor) settings).setDynamicBounds(true);
	}

	public static void dropsNothing(class_2251 settings) {
		((BlockSettingsAccessor) settings).invokeDropsNothing();
	}
}
