/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.world.v1.gen;

import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2798;
import net.minecraft.class_2888;
import net.minecraft.class_2960;

/**
 * Wrapper class that allows for {@link ChunkGeneratorType} creation.
 * The standard {@link ChunkGeneratorType} class constructor requires a {@link net.minecraft.world.gen.chunk.ChunkGeneratorFactory}, which is protected.
 *
 * @param <C>  config of the {@link ChunkGenerator} stored by this type
 * @param <T>  {@link ChunkGenerator} stored by this type
 */
public final class FabricChunkGeneratorType<C extends class_2888, T extends class_2794<C>> extends class_2798<C, T> {
	private final FabricChunkGeneratorFactory<C, T> factory;

	private FabricChunkGeneratorType(FabricChunkGeneratorFactory<C, T> factory, boolean buffetScreenOption, Supplier<C> settingsSupplier) {
		super(null, buffetScreenOption, settingsSupplier);
		this.factory = factory;
	}

	/**
	 * Registers and returns a new instance of {@link ChunkGeneratorType}.
	 *
	 * @param id                 registry ID of the ChunkGeneratorType
	 * @param factory            factory instance to provide a ChunkGenerator
	 * @param settingsSupplier   config supplier
	 * @param buffetScreenOption whether or not the ChunkGeneratorType should appear in the buffet screen options page
	 */
	public static <C extends class_2888, T extends class_2794<C>> FabricChunkGeneratorType<C, T> register(class_2960 id, FabricChunkGeneratorFactory<C, T> factory, Supplier<C> settingsSupplier, boolean buffetScreenOption) {
		return class_2378.method_10230(class_2378.field_11149, id, new FabricChunkGeneratorType<>(factory, buffetScreenOption, settingsSupplier));
	}

	/**
	 * Creates and returns an instance of the ChunkGeneratorType's ChunkGenerator.
	 *
	 * @param world       DimensionType's world instance
	 * @param biomeSource BiomeSource to use while generating the world
	 * @param config      ChunkGenerator config instance
	 */
	@Override
	public T create(class_1937 world, class_1966 biomeSource, C config) {
		return factory.create(world, biomeSource, config);
	}

	/**
	 * Responsible for creating the FabricChunkGeneratorType's ChunkGenerator instance.
	 * Called when a new instance of a ChunkGenerator is requested in {@link FabricChunkGeneratorType#create(World, BiomeSource, ChunkGeneratorConfig)}.
	 *
	 * @param <C>  ChunkGeneratorConfig
	 * @param <T>  ChunkGenerator
	 */
	@FunctionalInterface
	public interface FabricChunkGeneratorFactory<C extends class_2888, T extends class_2794<C>> {
		T create(class_1937 world, class_1966 source, C config);
	}
}
