/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.block;

import java.util.function.Function;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3620;

/**
 * @deprecated Please migrate to v1. Please use {@link net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings} instead
 */
@Deprecated
public class FabricBlockSettings {
	protected final net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings delegate;

	protected FabricBlockSettings(class_3614 material, class_3620 color) {
		this(class_2248.Settings.method_9639(material, color));
	}

	protected FabricBlockSettings(class_2248 base) {
		this(class_2248.Settings.method_9630(base));
	}

	protected FabricBlockSettings(final class_2248.Settings delegate) {
		this.delegate = net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings.copyOf(delegate);
	}

	public static FabricBlockSettings of(class_3614 material) {
		return of(material, material.method_15803());
	}

	public static FabricBlockSettings of(class_3614 material, class_3620 color) {
		return new FabricBlockSettings(material, color);
	}

	public static FabricBlockSettings of(class_3614 material, class_1767 color) {
		return new FabricBlockSettings(material, color.method_7794());
	}

	public static FabricBlockSettings copy(class_2248 base) {
		return new FabricBlockSettings(base);
	}

	public static FabricBlockSettings copyOf(class_2248.Settings settings) {
		return new FabricBlockSettings(settings);
	}

	/* FABRIC HELPERS */

	/**
	 * Makes the block breakable by any tool if {@code breakByHand} is set to true.
	 */
	public FabricBlockSettings breakByHand(boolean breakByHand) {
		this.delegate.breakByHand(breakByHand);
		return this;
	}

	/**
	 * Please make the block require a tool if you plan to disable drops and slow the breaking down using the
	 * incorrect tool by using {@link net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings#method_29292()}.
	 */
	public FabricBlockSettings breakByTool(class_3494<class_1792> tag, int miningLevel) {
		this.delegate.breakByTool(tag, miningLevel);
		return this;
	}

	/**
	 * Please make the block require a tool if you plan to disable drops and slow the breaking down using the
	 * incorrect tool by using {@link net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings#method_29292()}.
	 */
	public FabricBlockSettings breakByTool(class_3494<class_1792> tag) {
		this.delegate.breakByTool(tag);
		return this;
	}

	/* DELEGATE WRAPPERS */

	public FabricBlockSettings materialColor(class_3620 color) {
		this.delegate.materialColor(color);
		return this;
	}

	public FabricBlockSettings materialColor(class_1767 color) {
		this.delegate.materialColor(color.method_7794());
		return this;
	}

	public FabricBlockSettings collidable(boolean collidable) {
		this.delegate.collidable(collidable);
		return this;
	}

	public FabricBlockSettings noCollision() {
		this.delegate.method_9634();
		return this;
	}

	public FabricBlockSettings nonOpaque() {
		this.delegate.method_22488();
		return this;
	}

	public FabricBlockSettings sounds(class_2498 group) {
		this.delegate.method_9626(group);
		return this;
	}

	public FabricBlockSettings ticksRandomly() {
		this.delegate.method_9640();
		return this;
	}

	public FabricBlockSettings lightLevel(int lightLevel) {
		this.delegate.lightLevel(lightLevel);
		return this;
	}

	public FabricBlockSettings hardness(float hardness) {
		this.delegate.hardness(hardness);
		return this;
	}

	public FabricBlockSettings resistance(float resistance) {
		this.delegate.resistance(resistance);
		return this;
	}

	public FabricBlockSettings strength(float hardness, float resistance) {
		this.delegate.method_9629(hardness, resistance);
		return this;
	}

	public FabricBlockSettings breakInstantly() {
		this.delegate.method_9618();
		return this;
	}

	public FabricBlockSettings dropsNothing() {
		this.delegate.method_16229();
		return this;
	}

	public FabricBlockSettings dropsLike(class_2248 block) {
		this.delegate.method_16228(block);
		return this;
	}

	public FabricBlockSettings drops(class_2960 dropTableId) {
		this.delegate.drops(dropTableId);
		return this;
	}

	@Deprecated
	public FabricBlockSettings friction(float friction) {
		this.delegate.method_9628(friction);
		return this;
	}

	public FabricBlockSettings slipperiness(float value) {
		this.delegate.method_9628(value);
		return this;
	}

	public FabricBlockSettings dynamicBounds() {
		this.delegate.method_9624();
		return this;
	}

	/* BUILDING LOGIC */

	public class_2248.Settings build() {
		return this.delegate;
	}

	public <T> T build(Function<class_2248.Settings, T> function) {
		return function.apply(this.delegate);
	}
}
