/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.particle;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.particle.v1.FabricSpriteProvider;
import net.fabricmc.fabric.impl.client.particle.ParticleFactoryRegistryImpl;
import net.fabricmc.fabric.impl.client.particle.VanillaParticleManager;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4089;

public final class FabricParticleManager {
    private final VanillaParticleManager manager;
    private final Int2ObjectMap<FabricSpriteProviderImpl> providers = new Int2ObjectOpenHashMap();

    public FabricParticleManager(VanillaParticleManager manager) {
        this.manager = manager;
    }

    public void injectValues() {
        this.manager.getFactories().putAll(ParticleFactoryRegistryImpl.INSTANCE.factories);
        ParticleFactoryRegistryImpl.INSTANCE.constructors.forEach((id, factory) -> {
            FabricSpriteProviderImpl provider = new FabricSpriteProviderImpl();
            this.providers.put(id.intValue(), (Object)provider);
            this.manager.getFactories().put(id.intValue(), factory.create(provider));
        });
    }

    private FabricSpriteProviderImpl getProvider(class_2960 id) {
        if (!ParticleFactoryRegistryImpl.INSTANCE.constructorsIdsMap.containsKey(id)) {
            return null;
        }
        return (FabricSpriteProviderImpl)this.providers.get(ParticleFactoryRegistryImpl.INSTANCE.constructorsIdsMap.get(id).intValue());
    }

    public boolean loadParticle(class_3300 manager, class_2960 id) {
        FabricSpriteProviderImpl provider = this.getProvider(id);
        if (provider == null) {
            return false;
        }
        class_2960 file = new class_2960(id.method_12836(), "particles/" + id.method_12832() + ".json");
        try (InputStreamReader reader = new InputStreamReader(manager.method_14486(file).method_14482(), StandardCharsets.UTF_8);){
            List spriteIds = class_4089.method_18828((JsonObject)class_3518.method_15255((Reader)reader)).method_18826();
            if (spriteIds == null) {
                throw new IllegalStateException("(Fabric) Missing texture list for particle " + id);
            }
            provider.setSprites(spriteIds);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load description for particle " + id, e);
        }
        return true;
    }

    private final class FabricSpriteProviderImpl
    implements FabricSpriteProvider {
        private List<class_2960> spriteIds;
        private List<class_1058> sprites;

        private FabricSpriteProviderImpl() {
        }

        public class_1058 method_18138(int min, int max) {
            return this.getSprites().get(min * (this.getSprites().size() - 1) / max);
        }

        public class_1058 method_18139(Random random_1) {
            return this.getSprites().get(random_1.nextInt(this.getSprites().size()));
        }

        @Override
        public class_1059 getAtlas() {
            return FabricParticleManager.this.manager.getAtlas();
        }

        @Override
        public List<class_1058> getSprites() {
            if (this.sprites == null) {
                this.sprites = this.spriteIds.stream().map(arg_0 -> ((class_1059)this.getAtlas()).method_4608(arg_0)).collect(Collectors.toList());
            }
            return this.sprites;
        }

        public void setSprites(List<class_2960> sprites) {
            this.sprites = null;
            this.spriteIds = ImmutableList.copyOf(sprites);
        }
    }
}

