/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.particle;

import java.util.HashMap;
import java.util.Map;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_707;

public final class ParticleFactoryRegistryImpl implements ParticleFactoryRegistry {
	public static final ParticleFactoryRegistryImpl INSTANCE = new ParticleFactoryRegistryImpl();

	final Int2ObjectMap<class_707<?>> factories = new Int2ObjectOpenHashMap<>();
	final Int2ObjectMap<PendingParticleFactory<?>> constructors = new Int2ObjectOpenHashMap<>();
	final Map<class_2960, Integer> constructorsIdsMap = new HashMap<>();

	private ParticleFactoryRegistryImpl() { }

	@Override
	public <T extends class_2394> void register(class_2396<T> type, class_707<T> factory) {
		factories.put(class_2378.field_11141.method_10249(type), factory);
	}

	@Override
	public <T extends class_2394> void register(class_2396<T> type, PendingParticleFactory<T> factory) {
		constructors.put(class_2378.field_11141.method_10249(type), factory);
		constructorsIdsMap.put(class_2378.field_11141.method_10221(type), class_2378.field_11141.method_10249(type));
	}
}
