/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.particle;

import java.lang.reflect.Constructor;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.impl.client.particle.FabricSpriteProviderImpl;
import net.fabricmc.fabric.mixin.client.particle.ParticleManagerAccessor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_4002;
import net.minecraft.class_702;
import net.minecraft.class_707;

public final class ParticleFactoryRegistryImpl
implements ParticleFactoryRegistry {
    public static final ParticleFactoryRegistryImpl INSTANCE = new ParticleFactoryRegistryImpl();
    ParticleFactoryRegistry internalRegistry = new DeferredParticleFactoryRegistry();

    private ParticleFactoryRegistryImpl() {
    }

    @Override
    public <T extends class_2394> void register(class_2396<T> type, class_707<T> factory) {
        this.internalRegistry.register(type, factory);
    }

    @Override
    public <T extends class_2394> void register(class_2396<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> constructor) {
        this.internalRegistry.register(type, constructor);
    }

    public void initialize(class_702 particleManager) {
        DirectParticleFactoryRegistry newRegistry = new DirectParticleFactoryRegistry(particleManager);
        DeferredParticleFactoryRegistry oldRegistry = (DeferredParticleFactoryRegistry)this.internalRegistry;
        oldRegistry.applyTo(newRegistry);
        this.internalRegistry = newRegistry;
    }

    static class DirectParticleFactoryRegistry
    implements ParticleFactoryRegistry {
        private static final Constructor<? extends class_4002> SIMPLE_SPRITE_PROVIDER_CONSTRUCTOR;
        private final class_702 particleManager;

        private static class_4002 createSimpleSpriteProvider(class_702 particleManager) {
            try {
                return SIMPLE_SPRITE_PROVIDER_CONSTRUCTOR.newInstance(particleManager);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create SimpleSpriteProvider", e);
            }
        }

        DirectParticleFactoryRegistry(class_702 particleManager) {
            this.particleManager = particleManager;
        }

        @Override
        public <T extends class_2394> void register(class_2396<T> type, class_707<T> factory) {
            ((ParticleManagerAccessor)this.particleManager).getFactories().put(class_2378.field_11141.method_10206(type), factory);
        }

        @Override
        public <T extends class_2394> void register(class_2396<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> constructor) {
            class_4002 delegate = DirectParticleFactoryRegistry.createSimpleSpriteProvider(this.particleManager);
            FabricSpriteProviderImpl fabricSpriteProvider = new FabricSpriteProviderImpl(this.particleManager, delegate);
            ((ParticleManagerAccessor)this.particleManager).getSpriteAwareFactories().put(class_2378.field_11141.method_10221(type), delegate);
            this.register(type, constructor.create(fabricSpriteProvider));
        }

        static {
            try {
                String intermediaryClassName = "net.minecraft.class_702$class_4090";
                String currentClassName = FabricLoader.getInstance().getMappingResolver().mapClassName("intermediary", intermediaryClassName);
                Class<?> clazz = Class.forName(currentClassName);
                SIMPLE_SPRITE_PROVIDER_CONSTRUCTOR = clazz.getDeclaredConstructor(class_702.class);
                SIMPLE_SPRITE_PROVIDER_CONSTRUCTOR.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to register particles", e);
            }
        }
    }

    static class DeferredParticleFactoryRegistry
    implements ParticleFactoryRegistry {
        private final Map<class_2396<?>, class_707<?>> factories = new IdentityHashMap();
        private final Map<class_2396<?>, ParticleFactoryRegistry.PendingParticleFactory<?>> constructors = new IdentityHashMap();

        DeferredParticleFactoryRegistry() {
        }

        @Override
        public <T extends class_2394> void register(class_2396<T> type, class_707<T> factory) {
            this.factories.put(type, factory);
        }

        @Override
        public <T extends class_2394> void register(class_2396<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> factory) {
            this.constructors.put(type, factory);
        }

        void applyTo(ParticleFactoryRegistry registry) {
            class_2396<?> type;
            for (Map.Entry<class_2396<?>, class_707<?>> entry : this.factories.entrySet()) {
                type = entry.getKey();
                class_707<?> factory = entry.getValue();
                registry.register(type, factory);
            }
            for (Map.Entry<class_2396<?>, Object> entry : this.constructors.entrySet()) {
                type = entry.getKey();
                ParticleFactoryRegistry.PendingParticleFactory constructor = (ParticleFactoryRegistry.PendingParticleFactory)entry.getValue();
                registry.register(type, constructor);
            }
        }
    }
}

