/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.particle;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_4002;
import net.minecraft.class_702;
import net.minecraft.class_707;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(class_702.class)
public interface ParticleManagerAccessor {
	@Accessor("particleAtlasTexture")
	class_1059 getParticleAtlasTexture();

	@Accessor("factories")
	Int2ObjectMap<class_707<?>> getFactories();

	// NOTE: The field signature is actually Map<Identifier, SimpleSpriteProvider>
	// This still works due to type erasure
	@Accessor("spriteAwareFactories")
	Map<class_2960, class_4002> getSpriteAwareFactories();

	@Mixin(class_702.class_4090.class)
	interface SimpleSpriteProviderAccessor {
		@Accessor("sprites")
		List<class_1058> getSprites();
	}
}
