/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.particle;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.particle.v1.FabricSpriteProvider;
import net.fabricmc.fabric.mixin.client.particle.ParticleManagerAccessor;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_4002;
import net.minecraft.class_702;
import net.minecraft.class_707;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;

public final class ParticleFactoryRegistryImpl implements ParticleFactoryRegistry {
	public static final ParticleFactoryRegistryImpl INSTANCE = new ParticleFactoryRegistryImpl();

	static class DeferredParticleFactoryRegistry implements ParticleFactoryRegistry {
		private final Map<class_2396<?>, class_707<?>> factories = new IdentityHashMap<>();
		private final Map<class_2396<?>, PendingParticleFactory<?>> constructors = new IdentityHashMap<>();

		@Override
		public <T extends class_2394> void register(class_2396<T> type, class_707<T> factory) {
			factories.put(type, factory);
		}

		@Override
		public <T extends class_2394> void register(class_2396<T> type, PendingParticleFactory<T> factory) {
			constructors.put(type, factory);
		}

		@SuppressWarnings("unchecked")
		void applyTo(ParticleFactoryRegistry registry) {
			for (Map.Entry<class_2396<?>, class_707<?>> entry : factories.entrySet()) {
				class_2396 type = entry.getKey();
				class_707 factory = entry.getValue();
				registry.register(type, factory);
			}

			for (Map.Entry<class_2396<?>, PendingParticleFactory<?>> entry : constructors.entrySet()) {
				class_2396 type = entry.getKey();
				PendingParticleFactory constructor = entry.getValue();
				registry.register(type, constructor);
			}
		}
	}

	static class DirectParticleFactoryRegistry implements ParticleFactoryRegistry {
		private final class_702 particleManager;

		DirectParticleFactoryRegistry(class_702 particleManager) {
			this.particleManager = particleManager;
		}

		@Override
		public <T extends class_2394> void register(class_2396<T> type, class_707<T> factory) {
			((ParticleManagerAccessor) particleManager).getFactories().put(class_2378.field_11141.method_10206(type), factory);
		}

		@Override
		public <T extends class_2394> void register(class_2396<T> type, PendingParticleFactory<T> constructor) {
			class_4002 delegate = new class_702.class_4090();
			FabricSpriteProvider fabricSpriteProvider = new FabricSpriteProviderImpl(particleManager, delegate);
			((ParticleManagerAccessor) particleManager).getSpriteAwareFactories().put(class_2378.field_11141.method_10221(type), delegate);
			register(type, constructor.create(fabricSpriteProvider));
		}
	}

	ParticleFactoryRegistry internalRegistry = new DeferredParticleFactoryRegistry();

	private ParticleFactoryRegistryImpl() { }

	@Override
	public <T extends class_2394> void register(class_2396<T> type, class_707<T> factory) {
		internalRegistry.register(type, factory);
	}

	@Override
	public <T extends class_2394> void register(class_2396<T> type, PendingParticleFactory<T> constructor) {
		internalRegistry.register(type, constructor);
	}

	public void initialize(class_702 particleManager) {
		ParticleFactoryRegistry newRegistry = new DirectParticleFactoryRegistry(particleManager);
		DeferredParticleFactoryRegistry oldRegistry = (DeferredParticleFactoryRegistry) internalRegistry;
		oldRegistry.applyTo(newRegistry);
		internalRegistry = newRegistry;
	}
}
