/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.particle;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.impl.client.particle.FabricSpriteProviderImpl;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleResources;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;

public final class ParticleFactoryRegistryImpl
implements ParticleFactoryRegistry {
    public static final ParticleFactoryRegistryImpl INSTANCE = new ParticleFactoryRegistryImpl();
    ParticleFactoryRegistry internalRegistry = new DeferredParticleFactoryRegistry();

    private ParticleFactoryRegistryImpl() {
    }

    @Override
    public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProvider<T> factory) {
        this.internalRegistry.register(type, factory);
    }

    @Override
    public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> constructor) {
        this.internalRegistry.register(type, constructor);
    }

    public void initialize(ParticleResources particleSpriteManager) {
        DirectParticleFactoryRegistry newRegistry = new DirectParticleFactoryRegistry(particleSpriteManager);
        DeferredParticleFactoryRegistry oldRegistry = (DeferredParticleFactoryRegistry)this.internalRegistry;
        oldRegistry.applyTo(newRegistry);
        this.internalRegistry = newRegistry;
    }

    static class DeferredParticleFactoryRegistry
    implements ParticleFactoryRegistry {
        private final Map<ParticleType<?>, ParticleProvider<?>> factories = new IdentityHashMap();
        private final Map<ParticleType<?>, ParticleFactoryRegistry.PendingParticleFactory<?>> constructors = new IdentityHashMap();

        DeferredParticleFactoryRegistry() {
        }

        @Override
        public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProvider<T> factory) {
            this.factories.put(type, factory);
        }

        @Override
        public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> factory) {
            this.constructors.put(type, factory);
        }

        void applyTo(ParticleFactoryRegistry registry) {
            ParticleType<?> type;
            for (Map.Entry<ParticleType<?>, ParticleProvider<?>> entry : this.factories.entrySet()) {
                type = entry.getKey();
                ParticleProvider<?> factory = entry.getValue();
                registry.register(type, factory);
            }
            for (Map.Entry<ParticleType<?>, Object> entry : this.constructors.entrySet()) {
                type = entry.getKey();
                ParticleFactoryRegistry.PendingParticleFactory constructor = (ParticleFactoryRegistry.PendingParticleFactory)entry.getValue();
                registry.register(type, constructor);
            }
        }
    }

    record DirectParticleFactoryRegistry(ParticleResources particleSpriteManager) implements ParticleFactoryRegistry
    {
        @Override
        public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProvider<T> factory) {
            this.particleSpriteManager.providers.put(BuiltInRegistries.PARTICLE_TYPE.getId(type), factory);
        }

        @Override
        public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> constructor) {
            ParticleResources.MutableSpriteSet delegate = new ParticleResources.MutableSpriteSet();
            FabricSpriteProviderImpl fabricSpriteProvider = new FabricSpriteProviderImpl(delegate);
            this.particleSpriteManager.spriteSets.put(BuiltInRegistries.PARTICLE_TYPE.getKey(type), delegate);
            this.register(type, constructor.create(fabricSpriteProvider));
        }
    }
}

