/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.particle;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import net.fabricmc.fabric.impl.particle.BlockStateParticleEffectExtension;
import net.minecraft.class_1306;
import net.minecraft.class_1937;
import net.minecraft.class_2388;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_8162;

@Mixin(class_8162.class)
abstract class BrushItemMixin {
	@ModifyExpressionValue(method = "spawnDustParticles", at = @At(value = "NEW", target = "(Lnet/minecraft/core/particles/ParticleType;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/core/particles/BlockParticleOption;"))
	private class_2388 modifyBlockStateParticleEffect(class_2388 original, class_1937 world, class_3965 hitResult, class_2680 state, class_243 userRotation, class_1306 arm) {
		((BlockStateParticleEffectExtension) original).fabric_setBlockPos(hitResult.method_17777());
		return original;
	}
}
