/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class DifferenceIngredient implements CustomIngredient {
	public static final CustomIngredientSerializer<DifferenceIngredient> SERIALIZER = new Serializer();

	private final class_1856 base;
	private final class_1856 subtracted;

	public DifferenceIngredient(class_1856 base, class_1856 subtracted) {
		this.base = base;
		this.subtracted = subtracted;
	}

	@Override
	public boolean test(class_1799 stack) {
		return base.method_8093(stack) && !subtracted.method_8093(stack);
	}

	@Override
	public List<class_1799> getMatchingStacks() {
		List<class_1799> stacks = new ArrayList<>(List.of(base.method_8105()));
		stacks.removeIf(subtracted);
		return stacks;
	}

	@Override
	public boolean requiresTesting() {
		return base.requiresTesting() || subtracted.requiresTesting();
	}

	@Override
	public CustomIngredientSerializer<?> getSerializer() {
		return SERIALIZER;
	}

	private static class Serializer implements CustomIngredientSerializer<DifferenceIngredient> {
		private final class_2960 id = new class_2960("fabric", "difference");

		@Override
		public class_2960 getIdentifier() {
			return id;
		}

		@Override
		public DifferenceIngredient read(JsonObject json) {
			class_1856 base = class_1856.method_52177(json.get("base"));
			class_1856 subtracted = class_1856.method_52177(json.get("subtracted"));
			return new DifferenceIngredient(base, subtracted);
		}

		@Override
		public void write(JsonObject json, DifferenceIngredient ingredient) {
			json.add("base", ingredient.base.method_8089());
			json.add("subtracted", ingredient.subtracted.method_8089());
		}

		@Override
		public DifferenceIngredient read(class_2540 buf) {
			class_1856 base = class_1856.method_8086(buf);
			class_1856 subtracted = class_1856.method_8086(buf);
			return new DifferenceIngredient(base, subtracted);
		}

		@Override
		public void write(class_2540 buf, DifferenceIngredient ingredient) {
			ingredient.base.method_8088(buf);
			ingredient.subtracted.method_8088(buf);
		}
	}
}
