/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

abstract class CombinedIngredient
implements CustomIngredient {
    protected final List<class_1856> ingredients;

    protected CombinedIngredient(List<class_1856> ingredients) {
        if (ingredients.isEmpty()) {
            throw new IllegalArgumentException("ALL or ANY ingredient must have at least one sub-ingredient");
        }
        this.ingredients = ingredients;
    }

    @Override
    public boolean requiresTesting() {
        for (class_1856 ingredient : this.ingredients) {
            if (!ingredient.requiresTesting()) continue;
            return true;
        }
        return false;
    }

    List<class_1856> getIngredients() {
        return this.ingredients;
    }

    static class Serializer<I extends CombinedIngredient>
    implements CustomIngredientSerializer<I> {
        private final class_2960 identifier;
        private final Function<List<class_1856>, I> factory;
        private final Codec<I> allowEmptyCodec;
        private final Codec<I> disallowEmptyCodec;

        Serializer(class_2960 identifier, Function<List<class_1856>, I> factory, Codec<I> allowEmptyCodec, Codec<I> disallowEmptyCodec) {
            this.identifier = identifier;
            this.factory = factory;
            this.allowEmptyCodec = allowEmptyCodec;
            this.disallowEmptyCodec = disallowEmptyCodec;
        }

        @Override
        public class_2960 getIdentifier() {
            return this.identifier;
        }

        @Override
        public Codec<I> getCodec(boolean allowEmpty) {
            return allowEmpty ? this.allowEmptyCodec : this.disallowEmptyCodec;
        }

        @Override
        public I read(class_2540 buf) {
            int size = buf.method_10816();
            ArrayList<class_1856> ingredients = new ArrayList<class_1856>(size);
            for (int i = 0; i < size; ++i) {
                ingredients.add(class_1856.method_8086((class_2540)buf));
            }
            return (I)((CombinedIngredient)this.factory.apply(Collections.unmodifiableList(ingredients)));
        }

        @Override
        public void write(class_2540 buf, I ingredient) {
            buf.method_10804(((CombinedIngredient)ingredient).ingredients.size());
            for (class_1856 value : ((CombinedIngredient)ingredient).ingredients) {
                value.method_8088(buf);
            }
        }
    }
}

