/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public class NbtIngredient
implements CustomIngredient {
    public static final CustomIngredientSerializer<NbtIngredient> SERIALIZER = new Serializer();
    private final class_1856 base;
    @Nullable
    private final class_2487 nbt;
    private final boolean strict;

    public NbtIngredient(class_1856 base, @Nullable class_2487 nbt, boolean strict) {
        if (nbt == null && !strict) {
            throw new IllegalArgumentException("NbtIngredient can only have null NBT in strict mode");
        }
        this.base = base;
        this.nbt = nbt;
        this.strict = strict;
    }

    @Override
    public boolean test(class_1799 stack) {
        if (!this.base.method_8093(stack)) {
            return false;
        }
        if (this.strict) {
            return Objects.equals(this.nbt, stack.method_7969());
        }
        return class_2512.method_10687((class_2520)this.nbt, (class_2520)stack.method_7969(), (boolean)true);
    }

    @Override
    public List<class_1799> getMatchingStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(List.of(this.base.method_8105()));
        stacks.replaceAll(stack -> {
            class_1799 copy = stack.method_7972();
            if (this.nbt != null) {
                copy.method_7980(this.nbt.method_10553());
            }
            return copy;
        });
        stacks.removeIf(stack -> !this.base.method_8093(stack));
        return stacks;
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private class_1856 getBase() {
        return this.base;
    }

    private class_2487 getNbt() {
        return this.nbt;
    }

    private boolean isStrict() {
        return this.strict;
    }

    private static class Serializer
    implements CustomIngredientSerializer<NbtIngredient> {
        private static final class_2960 ID = new class_2960("fabric", "nbt");
        private static final Codec<class_2487> NBT_CODEC = class_5699.method_33817((Codec)Codec.STRING, (Codec)class_2487.field_25128).flatXmap(either -> (DataResult)either.map(s -> {
            try {
                return DataResult.success((Object)class_2522.method_10718((String)s));
            }
            catch (CommandSyntaxException e) {
                return DataResult.error(() -> ((CommandSyntaxException)e).getMessage());
            }
        }, DataResult::success), nbtCompound -> DataResult.success((Object)Either.left((Object)nbtCompound.method_10714())));
        private static final Codec<NbtIngredient> ALLOW_EMPTY_CODEC = Serializer.createCodec((Codec<class_1856>)class_1856.field_46095);
        private static final Codec<NbtIngredient> DISALLOW_EMPTY_CODEC = Serializer.createCodec((Codec<class_1856>)class_1856.field_46096);

        private Serializer() {
        }

        private static Codec<NbtIngredient> createCodec(Codec<class_1856> ingredientCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)ingredientCodec.fieldOf("base").forGetter(NbtIngredient::getBase), (App)NBT_CODEC.optionalFieldOf("nbt", null).forGetter(NbtIngredient::getNbt), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(NbtIngredient::isStrict)).apply((Applicative)instance, NbtIngredient::new));
        }

        @Override
        public class_2960 getIdentifier() {
            return ID;
        }

        @Override
        public Codec<NbtIngredient> getCodec(boolean allowEmpty) {
            return allowEmpty ? ALLOW_EMPTY_CODEC : DISALLOW_EMPTY_CODEC;
        }

        @Override
        public NbtIngredient read(class_2540 buf) {
            class_1856 base = class_1856.method_8086((class_2540)buf);
            class_2487 nbt = buf.method_10798();
            boolean strict = buf.readBoolean();
            return new NbtIngredient(base, nbt, strict);
        }

        @Override
        public void write(class_2540 buf, NbtIngredient ingredient) {
            ingredient.base.method_8088(buf);
            buf.method_10794((class_2520)ingredient.nbt);
            buf.method_52964(ingredient.strict);
        }
    }
}

