/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.recipe.ingredient;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.api.recipe.v1.ingredient.FabricIngredient;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientImpl;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1856.class})
public class IngredientMixin
implements FabricIngredient {
    @Inject(method={"createCodec"}, at={@At(value="RETURN")}, cancellable=true)
    private static void injectCodec(boolean allowEmpty, CallbackInfoReturnable<Codec<class_1856>> cir) {
        Codec customIngredientCodec = CustomIngredientImpl.CODEC.dispatch("fabric:type", CustomIngredient::getSerializer, serializer -> serializer.getCodec(allowEmpty));
        cir.setReturnValue((Object)class_5699.method_53702((Codec)customIngredientCodec, (Codec)((Codec)cir.getReturnValue())).xmap(either -> (class_1856)either.map(CustomIngredient::toVanilla, ingredient -> ingredient), ingredient -> {
            CustomIngredient customIngredient = ingredient.getCustomIngredient();
            return customIngredient == null ? Either.right((Object)ingredient) : Either.left((Object)customIngredient);
        }));
    }

    @Inject(at={@At(value="HEAD")}, method={"fromPacket"}, cancellable=true)
    private static void injectFromPacket(class_2540 buf, CallbackInfoReturnable<class_1856> cir) {
        int index = buf.readerIndex();
        if (buf.method_10816() == -1) {
            class_2960 type = buf.method_10810();
            CustomIngredientSerializer<?> serializer = CustomIngredientSerializer.get(type);
            if (serializer == null) {
                throw new IllegalArgumentException("Cannot deserialize custom ingredient of unknown type " + String.valueOf(type));
            }
            cir.setReturnValue((Object)serializer.read(buf).toVanilla());
        } else {
            buf.method_52988(index);
        }
    }
}

