/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.recipe.ingredient;

import java.util.ArrayList;
import java.util.List;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.recipe.ingredient.ShapelessMatch;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

@Mixin(class_1867.class)
public class ShapelessRecipeMixin {
	@Final
	@Shadow
	class_2371<class_1856> ingredients;
	@Unique
	private boolean fabric_requiresTesting = false;

	@Inject(at = @At("RETURN"), method = "<init>")
	private void cacheRequiresTesting(String group, class_7710 category, class_1799 output, class_2371<class_1856> input, CallbackInfo ci) {
		for (class_1856 ingredient : input) {
			if (ingredient.requiresTesting()) {
				fabric_requiresTesting = true;
				break;
			}
		}
	}

	@Inject(at = @At("HEAD"), method = "matches", cancellable = true)
	public void customIngredientMatch(class_8566 craftingInventory, class_1937 world, CallbackInfoReturnable<Boolean> cir) {
		if (fabric_requiresTesting) {
			List<class_1799> nonEmptyStacks = new ArrayList<>(craftingInventory.method_5439());

			for (int i = 0; i < craftingInventory.method_5439(); ++i) {
				class_1799 stack = craftingInventory.method_5438(i);

				if (!stack.method_7960()) {
					nonEmptyStacks.add(stack);
				}
			}

			cir.setReturnValue(ShapelessMatch.isMatch(nonEmptyStacks, ingredients));
		}
	}
}
