/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import net.minecraft.class_9331;

public class ComponentsIngredient implements CustomIngredient {
	public static final CustomIngredientSerializer<ComponentsIngredient> SERIALIZER = new Serializer();

	private final class_1856 base;
	private final class_9326 components;

	public ComponentsIngredient(class_1856 base, class_9326 components) {
		if (components.method_57848()) {
			throw new IllegalArgumentException("ComponentIngredient must have at least one defined component");
		}

		this.base = base;
		this.components = components;
	}

	@Override
	public boolean test(class_1799 stack) {
		if (!base.method_8093(stack)) return false;

		// None strict matching
		for (Map.Entry<class_9331<?>, Optional<?>> entry : components.method_57846()) {
			final class_9331<?> type = entry.getKey();
			final Optional<?> value = entry.getValue();

			if (value.isPresent()) {
				// Expect the stack to contain a matching component
				if (!stack.method_57826(type)) {
					return false;
				}

				if (!Objects.equals(value.get(), stack.method_57824(type))) {
					return false;
				}
			} else {
				// Expect the target stack to not contain this component
				if (stack.method_57826(type)) {
					return false;
				}
			}
		}

		return true;
	}

	@Override
	public List<class_1799> getMatchingStacks() {
		List<class_1799> stacks = new ArrayList<>(List.of(base.method_8105()));
		stacks.replaceAll(stack -> {
			class_1799 copy = stack.method_7972();

			stack.method_59692(components);

			return copy;
		});
		stacks.removeIf(stack -> !base.method_8093(stack));
		return stacks;
	}

	@Override
	public boolean requiresTesting() {
		return true;
	}

	@Override
	public CustomIngredientSerializer<?> getSerializer() {
		return SERIALIZER;
	}

	private class_1856 getBase() {
		return base;
	}

	@Nullable
	private class_9326 getComponents() {
		return components;
	}

	private static class Serializer implements CustomIngredientSerializer<ComponentsIngredient> {
		private static final class_2960 ID = class_2960.method_60655("fabric", "components");
		private static final MapCodec<ComponentsIngredient> ALLOW_EMPTY_CODEC = createCodec(class_1856.field_46095);
		private static final MapCodec<ComponentsIngredient> DISALLOW_EMPTY_CODEC = createCodec(class_1856.field_46096);
		private static final class_9139<class_9129, ComponentsIngredient> PACKET_CODEC = class_9139.method_56435(
				class_1856.field_48355, ComponentsIngredient::getBase,
				class_9326.field_49590, ComponentsIngredient::getComponents,
				ComponentsIngredient::new
		);

		private static MapCodec<ComponentsIngredient> createCodec(Codec<class_1856> ingredientCodec) {
			return RecordCodecBuilder.mapCodec(instance ->
					instance.group(
							ingredientCodec.fieldOf("base").forGetter(ComponentsIngredient::getBase),
							class_9326.field_49589.fieldOf("components").forGetter(ComponentsIngredient::getComponents)
					).apply(instance, ComponentsIngredient::new)
			);
		}

		@Override
		public class_2960 getIdentifier() {
			return ID;
		}

		@Override
		public MapCodec<ComponentsIngredient> getCodec(boolean allowEmpty) {
			return allowEmpty ? ALLOW_EMPTY_CODEC : DISALLOW_EMPTY_CODEC;
		}

		@Override
		public class_9139<class_9129, ComponentsIngredient> getPacketCodec() {
			return PACKET_CODEC;
		}
	}
}
