/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import java.util.ArrayList;
import java.util.List;

import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public class AllIngredient extends CombinedIngredient {
	private static final MapCodec<AllIngredient> CODEC = class_1856.field_46095
			.listOf()
			.fieldOf("ingredients")
			.xmap(AllIngredient::new, AllIngredient::getIngredients);

	public static final CustomIngredientSerializer<AllIngredient> SERIALIZER =
			new Serializer<>(class_2960.method_60655("fabric", "all"), AllIngredient::new, CODEC);

	public AllIngredient(List<class_1856> ingredients) {
		super(ingredients);
	}

	@Override
	public boolean test(class_1799 stack) {
		for (class_1856 ingredient : ingredients) {
			if (!ingredient.method_8093(stack)) {
				return false;
			}
		}

		return true;
	}

	@Override
	public List<class_6880<class_1792>> getMatchingStacks() {
		// There's always at least one sub ingredient, so accessing ingredients[0] is safe.
		List<class_6880<class_1792>> previewStacks = new ArrayList<>(ingredients.getFirst().method_8105());

		for (int i = 1; i < ingredients.size(); ++i) {
			class_1856 ing = ingredients.get(i);
			previewStacks.removeIf(entry -> !ing.method_8093(entry.comp_349().method_7854()));
		}

		return previewStacks;
	}

	@Override
	public CustomIngredientSerializer<?> getSerializer() {
		return SERIALIZER;
	}
}
