/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

abstract class CombinedIngredient
implements CustomIngredient {
    protected final List<class_1856> ingredients;

    protected CombinedIngredient(List<class_1856> ingredients) {
        if (ingredients.isEmpty()) {
            throw new IllegalArgumentException("ALL or ANY ingredient must have at least one sub-ingredient");
        }
        this.ingredients = ingredients;
    }

    @Override
    public boolean requiresTesting() {
        for (class_1856 ingredient : this.ingredients) {
            if (!ingredient.requiresTesting()) continue;
            return true;
        }
        return false;
    }

    List<class_1856> getIngredients() {
        return this.ingredients;
    }

    static class Serializer<I extends CombinedIngredient>
    implements CustomIngredientSerializer<I> {
        private final class_2960 identifier;
        private final MapCodec<I> codec;
        private final class_9139<class_9129, I> packetCodec;

        Serializer(class_2960 identifier, Function<List<class_1856>, I> factory, MapCodec<I> codec) {
            this.identifier = identifier;
            this.codec = codec;
            this.packetCodec = class_1856.field_48355.method_56433(class_9135.method_56363()).method_56432(factory, CombinedIngredient::getIngredients);
        }

        @Override
        public class_2960 getIdentifier() {
            return this.identifier;
        }

        @Override
        public MapCodec<I> getCodec() {
            return this.codec;
        }

        @Override
        public class_9139<class_9129, I> getPacketCodec() {
            return this.packetCodec;
        }
    }
}

