/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.recipe.ingredient;

import java.util.Set;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class CustomIngredientPacketCodec implements class_9139<class_9129, class_1856> {
	private static final int PACKET_MARKER = -1;
	private final class_9139<class_9129, class_1856> fallback;

	public CustomIngredientPacketCodec(class_9139<class_9129, class_1856> fallback) {
		this.fallback = fallback;
	}

	@Override
	public class_1856 decode(class_9129 buf) {
		int index = buf.readerIndex();

		if (buf.method_10816() != PACKET_MARKER) {
			// Reset index for vanilla's normal deserialization logic.
			buf.method_52988(index);
			return this.fallback.decode(buf);
		}

		class_2960 type = buf.method_10810();
		CustomIngredientSerializer<?> serializer = CustomIngredientSerializer.get(type);

		if (serializer == null) {
			throw new IllegalArgumentException("Cannot deserialize custom ingredient of unknown type " + type);
		}

		return serializer.getPacketCodec().decode(buf).toVanilla();
	}

	@Override
	@SuppressWarnings("unchecked")
	public void encode(class_9129 buf, class_1856 value) {
		CustomIngredient customIngredient = value.getCustomIngredient();

		if (shouldEncodeFallback(customIngredient)) {
			// The client doesn't support this custom ingredient, so we send the matching stacks as a regular ingredient.
			this.fallback.encode(buf, value);
			return;
		}

		// The client supports this custom ingredient, so we send it as a custom ingredient.
		buf.method_10804(PACKET_MARKER);
		buf.method_10812(customIngredient.getSerializer().getIdentifier());
		class_9139<class_9129, CustomIngredient> packetCodec = (class_9139<class_9129, CustomIngredient>) customIngredient.getSerializer().getPacketCodec();
		packetCodec.encode(buf, customIngredient);
	}

	private static boolean shouldEncodeFallback(CustomIngredient customIngredient) {
		if (customIngredient == null) {
			return true;
		}

		// Can be null if we're not writing a packet from the PacketEncoder; in that case, always write the full ingredient.
		// Chances are this is a mod's doing and the client has the Ingredient API with the relevant ingredients.
		Set<class_2960> supportedIngredients = CustomIngredientSync.CURRENT_SUPPORTED_INGREDIENTS.get();
		return supportedIngredients != null && !supportedIngredients.contains(customIngredient.getSerializer().getIdentifier());
	}
}
