/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.recipe.ingredient;

import java.util.Optional;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class OptionalCustomIngredientPacketCodec implements class_9139<class_9129, Optional<class_1856>> {
	private final class_9139<class_9129, Optional<class_1856>> fallback;

	public OptionalCustomIngredientPacketCodec(class_9139<class_9129, Optional<class_1856>> fallback) {
		this.fallback = fallback;
	}

	@Override
	public Optional<class_1856> decode(class_9129 buf) {
		int index = buf.readerIndex();

		if (buf.method_10816() != CustomIngredientPacketCodec.PACKET_MARKER) {
			// Reset index for vanilla's normal deserialization logic.
			buf.method_52988(index);
			return this.fallback.decode(buf);
		}

		class_2960 type = buf.method_10810();
		CustomIngredientSerializer<?> serializer = CustomIngredientSerializer.get(type);

		if (serializer == null) {
			throw new IllegalArgumentException("Cannot deserialize custom ingredient of unknown type " + type);
		}

		return Optional.of(serializer.getPacketCodec().decode(buf).toVanilla());
	}

	@Override
	@SuppressWarnings("unchecked")
	public void encode(class_9129 buf, Optional<class_1856> value) {
		if (value.isEmpty()) {
			this.fallback.encode(buf, value);
			return;
		}

		CustomIngredient customIngredient = value.get().getCustomIngredient();

		if (CustomIngredientPacketCodec.shouldEncodeFallback(customIngredient)) {
			// The client doesn't support this custom ingredient, so we send the matching stacks as a regular ingredient.
			this.fallback.encode(buf, value);
			return;
		}

		// The client supports this custom ingredient, so we send it as a custom ingredient.
		buf.method_10804(CustomIngredientPacketCodec.PACKET_MARKER);
		buf.method_10812(customIngredient.getSerializer().getIdentifier());
		class_9139<class_9129, CustomIngredient> packetCodec = (class_9139<class_9129, CustomIngredient>) customIngredient.getSerializer().getPacketCodec();
		packetCodec.encode(buf, customIngredient);
	}
}
