/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.recipe.sync;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.recipe.sync.RecipeSyncImpl;
import net.fabricmc.fabric.impl.recipe.sync.SyncedSerializerAwarePreparedRecipe;
import net.minecraft.class_10289;
import net.minecraft.class_1865;
import net.minecraft.class_8786;

@Mixin(class_10289.class)
public class PreparedRecipesMixin implements SyncedSerializerAwarePreparedRecipe {
	@Unique
	private Map<class_1865<?>, List<class_8786<?>>> bySyncedSerializer;

	@Inject(method = "of", at = @At("HEAD"))
	private static void provideSerializerMap(Iterable<class_8786<?>> recipes, CallbackInfoReturnable<class_10289> cir,
											@Share("bySerializer") LocalRef<IdentityHashMap<class_1865<?>, List<class_8786<?>>>> bySerializer) {
		var map = new IdentityHashMap<class_1865<?>, List<class_8786<?>>>();

		for (class_1865<?> serializer : RecipeSyncImpl.getSyncedSerializers()) {
			map.put(serializer, new ArrayList<>());
		}

		bySerializer.set(map);
	}

	@Inject(method = "of", at = @At(value = "INVOKE", target = "Lcom/google/common/collect/ImmutableMap$Builder;put(Ljava/lang/Object;Ljava/lang/Object;)Lcom/google/common/collect/ImmutableMap$Builder;"))
	private static void fillSerializerMap(Iterable<class_8786<?>> recipes, CallbackInfoReturnable<class_10289> cir, @Local class_8786<?> entry,
										@Share("bySerializer") LocalRef<IdentityHashMap<class_1865<?>, List<class_8786<?>>>> bySerializer) {
		List<class_8786<?>> list = bySerializer.get().get(entry.comp_1933().method_8119());

		if (list != null) {
			list.add(entry);
		}
	}

	@ModifyReturnValue(method = "of", at = @At("RETURN"))
	private static class_10289 attachSerializerMap(class_10289 original,
													@Share("bySerializer") LocalRef<IdentityHashMap<class_1865<?>, List<class_8786<?>>>> bySerializer) {
		((PreparedRecipesMixin) (Object) original).bySyncedSerializer = bySerializer.get();
		return original;
	}

	@Override
	public @Nullable List<class_8786<?>> fabric_getRecipesBySyncedSerializer(class_1865<?> serializer) {
		//noinspection unchecked
		return this.bySyncedSerializer.get(serializer);
	}
}
