/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient;

import java.util.Set;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientSync;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.crafting.Ingredient;
import org.jspecify.annotations.Nullable;

public class CustomIngredientPacketCodec
implements StreamCodec<RegistryFriendlyByteBuf, Ingredient> {
    static final int PACKET_MARKER = -1;
    private final StreamCodec<RegistryFriendlyByteBuf, Ingredient> fallback;

    public CustomIngredientPacketCodec(StreamCodec<RegistryFriendlyByteBuf, Ingredient> fallback) {
        this.fallback = fallback;
    }

    public Ingredient decode(RegistryFriendlyByteBuf buf) {
        int index = buf.readerIndex();
        if (buf.readVarInt() != -1) {
            buf.readerIndex(index);
            return (Ingredient)this.fallback.decode((Object)buf);
        }
        Identifier type = buf.readIdentifier();
        CustomIngredientSerializer<?> serializer = CustomIngredientSerializer.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Cannot deserialize custom ingredient of unknown type " + String.valueOf(type));
        }
        return ((CustomIngredient)serializer.getPacketCodec().decode((Object)buf)).toVanilla();
    }

    public void encode(RegistryFriendlyByteBuf buf, Ingredient value) {
        CustomIngredient customIngredient = value.getCustomIngredient();
        if (CustomIngredientPacketCodec.shouldEncodeFallback(customIngredient)) {
            this.fallback.encode((Object)buf, (Object)value);
            return;
        }
        buf.writeVarInt(-1);
        buf.writeIdentifier(customIngredient.getSerializer().getIdentifier());
        StreamCodec<RegistryFriendlyByteBuf, ?> packetCodec = customIngredient.getSerializer().getPacketCodec();
        packetCodec.encode((Object)buf, (Object)customIngredient);
    }

    static boolean shouldEncodeFallback(@Nullable CustomIngredient customIngredient) {
        if (customIngredient == null) {
            return true;
        }
        Set<Identifier> supportedIngredients = CustomIngredientSync.CURRENT_SUPPORTED_INGREDIENTS.get();
        return supportedIngredients != null && !supportedIngredients.contains(customIngredient.getSerializer().getIdentifier());
    }
}

