/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.sync;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.impl.recipe.sync.RecipeSyncImpl;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.SkipPacketDecoderException;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;

public record RecipeSyncPayloadS2C(List<Entry> entries) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeSyncPayloadS2C> CODEC = Entry.CODEC.apply(ByteBufCodecs.list()).map(RecipeSyncPayloadS2C::new, RecipeSyncPayloadS2C::entries);
    public static final CustomPacketPayload.Type<RecipeSyncPayloadS2C> ID = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"fabric", (String)"recipe_sync"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public record Entry(RecipeSerializer<?> serializer, List<RecipeHolder<?>> recipes) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> CODEC = StreamCodec.ofMember(Entry::write, Entry::read);

        private static Entry read(RegistryFriendlyByteBuf buf) {
            Identifier recipeSerializerId = buf.readIdentifier();
            RecipeSerializer recipeSerializer = (RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.getValue(recipeSerializerId);
            if (recipeSerializer == null || !RecipeSyncImpl.isSynced(recipeSerializer)) {
                throw new SkipPacketDecoderException("Tried syncing unsupported packet serializer '" + String.valueOf(recipeSerializerId) + "'!");
            }
            int count = buf.readVarInt();
            ArrayList list = new ArrayList();
            for (int i = 0; i < count; ++i) {
                ResourceKey id = buf.readResourceKey(Registries.RECIPE);
                Recipe recipe = (Recipe)recipeSerializer.streamCodec().decode((Object)buf);
                list.add(new RecipeHolder(id, recipe));
            }
            return new Entry(recipeSerializer, list);
        }

        private void write(RegistryFriendlyByteBuf buf) {
            buf.writeIdentifier(BuiltInRegistries.RECIPE_SERIALIZER.getKey(this.serializer));
            buf.writeVarInt(this.recipes.size());
            StreamCodec serializer = this.serializer.streamCodec();
            for (RecipeHolder<?> recipe : this.recipes) {
                buf.writeResourceKey(recipe.id());
                serializer.encode((Object)buf, (Object)recipe.value());
            }
        }
    }
}

