/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.registry.sync;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.fabricmc.fabric.impl.registry.sync.trackers.StateIdTracker;
import net.fabricmc.fabric.impl.registry.sync.trackers.vanilla.BlockInitTracker;
import net.fabricmc.fabric.impl.registry.sync.trackers.vanilla.BlockItemTracker;
import net.minecraft.class_1802;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2966;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

@Mixin(class_2966.class)
public class MixinBootstrap {
	@SuppressWarnings("unchecked")
	@Inject(method = "setOutputStreams", at = @At("RETURN"))
	private static void initialize(CallbackInfo info) {
		// These seemingly pointless accesses are done to make sure each
		// static initializer is called, to register vanilla-provided blocks
		// and items from the respective classes - otherwise, they would
		// duplicate our calls from below.
		Object oBiome = class_1972.field_9411;
		Object oBlock = class_2246.field_10124;
		Object oFluid = class_3612.field_15906;
		Object oItem = class_1802.field_8162;

		// state ID tracking
		StateIdTracker.register(class_2378.field_11146, class_2248.field_10651, (block) -> block.method_9595().method_11662());
		StateIdTracker.register(class_2378.field_11154, class_3611.field_15904, (fluid) -> fluid.method_15783().method_11662());

		// map tracking
		BlockItemTracker.register(class_2378.field_11142);

		// block initialization, like Blocks
		BlockInitTracker.register(class_2378.field_11146);

		RegistrySyncManager.bootstrapRegistries();
	}
}
