/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.registry.sync.packet;

import java.util.Map;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.impl.registry.sync.RegistryMapSerializer;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

/**
 * A method to sync registry ids using {@link class_2487} and {@link class_2540#method_10794}.
 * Kept here for old version support.
 */
// TODO: Remove
@Deprecated
public class NbtRegistryPacketHandler extends RegistryPacketHandler {
	private static final class_2960 ID = new class_2960("fabric", "registry/sync");

	private Map<class_2960, Object2IntMap<class_2960>> syncedRegistryMap;

	@Override
	public class_2960 getPacketId() {
		return ID;
	}

	@Override
	public void sendPacket(class_3222 player, Map<class_2960, Object2IntMap<class_2960>> registryMap) {
		class_2540 buf = PacketByteBufs.create();
		buf.method_10794(RegistryMapSerializer.toNbt(registryMap));
		sendPacket(player, buf);
	}

	@Override
	public void receivePacket(class_2540 buf) {
		computeBufSize(buf);
		class_2487 nbt = buf.method_10798();
		syncedRegistryMap = nbt != null ? RegistryMapSerializer.fromNbt(nbt) : null;
	}

	@Override
	public int getTotalPacketReceived() {
		return 1;
	}

	@Override
	public boolean isPacketFinished() {
		return true;
	}

	@Override
	@Nullable
	public Map<class_2960, Object2IntMap<class_2960>> getSyncedRegistryMap() {
		return syncedRegistryMap;
	}
}
