/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.registry.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

import com.mojang.serialization.Codec;
import org.jetbrains.annotations.Unmodifiable;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7655;
import net.minecraft.class_7655.class_7657;
import net.minecraft.class_7782;

public final class DynamicRegistriesImpl {
	private static final List<class_7655.class_7657<?>> DYNAMIC_REGISTRIES = new ArrayList<>(class_7655.field_39968);
	public static final Set<class_5321<?>> FABRIC_DYNAMIC_REGISTRY_KEYS = new HashSet<>();
	public static final Set<class_5321<? extends class_2378<?>>> DYNAMIC_REGISTRY_KEYS = new HashSet<>();
	public static final Set<class_5321<? extends class_2378<?>>> SKIP_EMPTY_SYNC_REGISTRIES = new HashSet<>();

	static {
		for (class_7655.class_7657<?> vanillaEntry : class_7655.field_39968) {
			DYNAMIC_REGISTRY_KEYS.add(vanillaEntry.comp_985());
		}
	}

	private DynamicRegistriesImpl() {
	}

	public static @Unmodifiable List<class_7655.class_7657<?>> getDynamicRegistries() {
		return List.copyOf(DYNAMIC_REGISTRIES);
	}

	public static <T> void register(class_5321<? extends class_2378<T>> key, Codec<T> codec) {
		Objects.requireNonNull(key, "Registry key cannot be null");
		Objects.requireNonNull(codec, "Codec cannot be null");

		if (!DYNAMIC_REGISTRY_KEYS.add(key)) {
			throw new IllegalArgumentException("Dynamic registry " + key + " has already been registered!");
		}

		var entry = new class_7655.class_7657<>(key, codec);
		DYNAMIC_REGISTRIES.add(entry);
		FABRIC_DYNAMIC_REGISTRY_KEYS.add(key);
	}

	public static <T> void addSyncedRegistry(class_5321<? extends class_2378<T>> registryKey, Codec<T> networkCodec, DynamicRegistries.SyncOption... options) {
		Objects.requireNonNull(registryKey, "Registry key cannot be null");
		Objects.requireNonNull(networkCodec, "Network codec cannot be null");
		Objects.requireNonNull(options, "Options cannot be null");

		if (!(class_7782.field_40588 instanceof HashMap<?, ?>)) {
			class_7782.field_40588 = new HashMap<>(class_7782.field_40588);
		}

		class_7782.field_40588.put(registryKey, new class_7782.class_7783<>(registryKey, networkCodec));

		for (DynamicRegistries.SyncOption option : options) {
			if (option == DynamicRegistries.SyncOption.SKIP_WHEN_EMPTY) {
				SKIP_EMPTY_SYNC_REGISTRIES.add(registryKey);
			}
		}
	}
}
