/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.registry.sync;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

import com.mojang.datafixers.util.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.impl.registry.sync.DynamicRegistriesImpl;
import net.fabricmc.fabric.impl.registry.sync.DynamicRegistryViewImpl;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7655;

@Mixin(class_7655.class)
public class RegistryLoaderMixin {
	@Inject(
			method = "load(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/registry/DynamicRegistryManager;Ljava/util/List;)Lnet/minecraft/registry/DynamicRegistryManager$Immutable;",
			at = @At(
					value = "INVOKE",
					target = "Ljava/util/List;forEach(Ljava/util/function/Consumer;)V",
					ordinal = 0
			),
			locals = LocalCapture.CAPTURE_FAILHARD
	)
	private static void beforeLoad(class_3300 resourceManager, class_5455 baseRegistryManager, List<class_7655.class_7657<?>> entries, CallbackInfoReturnable<class_5455.class_6890> cir, Map a, List<Pair<class_2385<?>, ?>> registriesList, class_6903.class_7863 registryManager) {
		Map<class_5321<? extends class_2378<?>>, class_2378<?>> registries = new IdentityHashMap<>(registriesList.size());

		for (Pair<class_2385<?>, ?> pair : registriesList) {
			registries.put(pair.getFirst().method_30517(), pair.getFirst());
		}

		DynamicRegistrySetupCallback.EVENT.invoker().onRegistrySetup(new DynamicRegistryViewImpl(registries));
	}

	// Vanilla doesn't mark namespaces in the directories of dynamic registries at all,
	// so we prepend the directories with the namespace if it's a modded registry registered using the Fabric API.
	@Inject(method = "getPath", at = @At("RETURN"), cancellable = true)
	private static void prependDirectoryWithNamespace(class_2960 id, CallbackInfoReturnable<String> info) {
		if (!id.method_12836().equals(class_2960.field_33381)
				&& DynamicRegistriesImpl.FABRIC_DYNAMIC_REGISTRY_KEYS.contains(class_5321.method_29180(id))) {
			final String newPath = id.method_12836() + "/" + info.getReturnValue();
			info.setReturnValue(newPath);
		}
	}
}
