/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.registry.sync;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class FabricRegistryInit implements ModInitializer {
	public static final class_2960 SYNC_COMPLETE_ID = new class_2960("fabric", "registry/sync/complete");

	@Override
	public void onInitialize() {
		ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.register(RegistrySyncManager::configureClient);
		ServerConfigurationNetworking.registerGlobalReceiver(SYNC_COMPLETE_ID, (server, handler, buf, responseSender) -> {
			handler.completeTask(RegistrySyncManager.SyncConfigurationTask.KEY);
		});

		// Synced in PlaySoundS2CPacket.
		RegistryAttributeHolder.get(class_7923.field_41172)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced with RegistryTagContainer from RegistryTagManager.
		RegistryAttributeHolder.get(class_7923.field_41173)
				.addAttribute(RegistryAttribute.SYNCED);

		// StatusEffectInstance serialises with raw id.
		RegistryAttributeHolder.get(class_7923.field_41174)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in ChunkDeltaUpdateS2CPacket among other places, a pallet is used when saving.
		RegistryAttributeHolder.get(class_7923.field_41175)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in EnchantmentScreenHandler
		RegistryAttributeHolder.get(class_7923.field_41176)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in EntitySpawnS2CPacket and RegistryTagManager
		RegistryAttributeHolder.get(class_7923.field_41177)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in RegistryTagManager
		RegistryAttributeHolder.get(class_7923.field_41178)
				.addAttribute(RegistryAttribute.SYNCED);

		// Saved and synced using string ID.
		RegistryAttributeHolder.get(class_7923.field_41179);

		// Doesnt seem to be accessed apart from registering?
		RegistryAttributeHolder.get(class_7923.field_41143);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41144);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41149);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41150);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41151);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41153);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41155);

		// Synced in ParticleS2CPacket
		RegistryAttributeHolder.get(class_7923.field_41180)
				.addAttribute(RegistryAttribute.SYNCED);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41156);

		// Synced. Vanilla uses raw ids in BlockEntityUpdateS2CPacket, and mods use the Vanilla syncing since 1.18
		RegistryAttributeHolder.get(class_7923.field_41181)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in PaintingSpawnS2CPacket
		RegistryAttributeHolder.get(class_7923.field_41182)
				.addAttribute(RegistryAttribute.SYNCED);

		// Doesnt seem to be synced or saved, STAT_TYPE seems to handle the syncing.
		RegistryAttributeHolder.get(class_7923.field_41183);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41184);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41147);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41146);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41185);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41186);

		RegistryAttributeHolder.get(class_7923.field_41161);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41162);

		// Uses a data tracker (and thus, raw IDs) to sync cat entities to the client
		RegistryAttributeHolder.get(class_7923.field_41163)
				.addAttribute(RegistryAttribute.SYNCED);

		// Uses a data tracker (and thus, raw IDs) to sync frog entities to the client
		RegistryAttributeHolder.get(class_7923.field_41164)
				.addAttribute(RegistryAttribute.SYNCED);

		// Uses a data tracker (and thus, raw IDs) to sync painting entities to the client
		RegistryAttributeHolder.get(class_7923.field_41182)
				.addAttribute(RegistryAttribute.SYNCED);

		//  Uses the raw ID when syncing the command tree to the client
		RegistryAttributeHolder.get(class_7923.field_41192)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in OpenScreenS2CPacket
		RegistryAttributeHolder.get(class_7923.field_41187)
				.addAttribute(RegistryAttribute.SYNCED);

		// Does not seem to be serialised, only queried by id. Not synced
		RegistryAttributeHolder.get(class_7923.field_41188);

		// Synced by id
		RegistryAttributeHolder.get(class_7923.field_41189);

		// Synced and saved by id
		RegistryAttributeHolder.get(class_7923.field_41190);

		// Synced in StatisticsS2CPacket
		RegistryAttributeHolder.get(class_7923.field_41193)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID in TrackedDataHandlerRegistry.VILLAGER_DATA
		RegistryAttributeHolder.get(class_7923.field_41194)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID in TrackedDataHandlerRegistry.VILLAGER_DATA
		RegistryAttributeHolder.get(class_7923.field_41195)
				.addAttribute(RegistryAttribute.SYNCED);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41128);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_7923.field_41129);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41130);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41131);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41132);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41133);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41134);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_7923.field_41135);

		// Synced in TagManager::toPacket/fromPacket -> TagGroup::serialize/deserialize
		RegistryAttributeHolder.get(class_7923.field_41171)
				.addAttribute(RegistryAttribute.SYNCED);
	}
}
