/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.registry;

import com.mojang.serialization.Lifecycle;
import java.util.EnumSet;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.mixin.registry.sync.RegistriesAccessor;
import net.minecraft.class_2348;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_9248;

public final class FabricRegistryBuilder<T, R extends class_2385<T>> {
    private final R registry;
    private final EnumSet<RegistryAttribute> attributes = EnumSet.noneOf(RegistryAttribute.class);

    public static <T, R extends class_2385<T>> FabricRegistryBuilder<T, R> from(R registry) {
        return new FabricRegistryBuilder<T, R>(registry);
    }

    public static <T> FabricRegistryBuilder<T, class_2370<T>> createSimple(class_5321<class_2378<T>> registryKey) {
        return FabricRegistryBuilder.from(new class_2370(registryKey, Lifecycle.stable(), false));
    }

    public static <T> FabricRegistryBuilder<T, class_2348<T>> createDefaulted(class_5321<class_2378<T>> registryKey, class_2960 defaultId) {
        return FabricRegistryBuilder.from(new class_2348(defaultId.toString(), registryKey, Lifecycle.stable(), false));
    }

    @Deprecated
    public static <T> FabricRegistryBuilder<T, class_2370<T>> createSimple(Class<T> type, class_2960 registryId) {
        return FabricRegistryBuilder.createSimple(class_5321.method_29180((class_2960)registryId));
    }

    @Deprecated
    public static <T> FabricRegistryBuilder<T, class_2348<T>> createDefaulted(Class<T> type, class_2960 registryId, class_2960 defaultId) {
        return FabricRegistryBuilder.createDefaulted(class_5321.method_29180((class_2960)registryId), defaultId);
    }

    private FabricRegistryBuilder(R registry) {
        this.registry = registry;
        this.attribute(RegistryAttribute.MODDED);
    }

    public FabricRegistryBuilder<T, R> attribute(RegistryAttribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public R buildAndRegister() {
        class_5321 key = this.registry.method_30517();
        for (RegistryAttribute attribute : this.attributes) {
            RegistryAttributeHolder.get(key).addAttribute(attribute);
        }
        RegistriesAccessor.getROOT().method_10272(key, this.registry, class_9248.field_49136);
        return this.registry;
    }
}

