/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.registry.sync;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.DynamicRegistryView;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

public final class DynamicRegistryViewImpl implements DynamicRegistryView {
	private final Map<class_5321<? extends class_2378<?>>, class_2378<?>> registries;

	public DynamicRegistryViewImpl(Map<class_5321<? extends class_2378<?>>, class_2378<?>> registries) {
		this.registries = registries;
	}

	@Override
	public class_5455 asDynamicRegistryManager() {
		return new class_5455.class_6890() {
			@SuppressWarnings("unchecked")
			public <T> Optional<class_2378<T>> method_33310(class_5321<? extends class_2378<? extends T>> key) {
				return Optional.ofNullable((class_2378<T>) DynamicRegistryViewImpl.this.registries.get(key));
			}

			public Stream<class_6892<?>> method_40311() {
				return DynamicRegistryViewImpl.this.stream()
						.map(this::entry);
			}

			private <T> class_6892<T> entry(class_2378<T> registry) {
				return new class_6892<>(registry.method_30517(), registry);
			}

			public class_6890 method_40316() {
				return this;
			}
		};
	}

	@Override
	public Stream<class_2378<?>> stream() {
		return this.registries.values().stream();
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> Optional<class_2378<T>> getOptional(class_5321<? extends class_2378<? extends T>> registryRef) {
		return Optional.ofNullable((class_2378<T>) this.registries.get(registryRef));
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> void registerEntryAdded(class_5321<? extends class_2378<? extends T>> registryRef, RegistryEntryAddedCallback<T> callback) {
		class_2378<T> registry = (class_2378<T>) this.registries.get(registryRef);

		if (registry != null) {
			RegistryEntryAddedCallback.event(registry).register(callback);
		}
	}
}
