/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.registry.sync;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

// Adds namespaces to tag directories for registries added by mods.
@Mixin(class_3505.class)
abstract class TagManagerLoaderMixin {
	@WrapOperation(
			method = "buildRequiredGroup",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/registry/RegistryKeys;getTagPath(Lnet/minecraft/registry/RegistryKey;)Ljava/lang/String;"
			)
	)
	private String prependDirectoryWithNamespace(class_5321<? extends class_2378<?>> registryKey, Operation<String> original) {
		class_2960 id = registryKey.method_29177();

		// Vanilla doesn't mark namespaces in the directories of tags at all,
		// so we prepend the directories with the namespace if it's a modded registry id.
		// No need to check DIRECTORIES, since this is only used by vanilla registries.
		if (!id.method_12836().equals(class_2960.field_33381)) {
			return "tags/" + id.method_12836() + "/" + id.method_12832();
		}

		return original.call(registryKey);
	}
}
