/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.registry.sync;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;

public class RegistryMapSerializer {
	public static final int VERSION = 1;

	public static Map<class_2960, Object2IntMap<class_2960>> fromNbt(class_2487 nbt) {
		class_2487 mainNbt = nbt.method_10562("registries");
		Map<class_2960, Object2IntMap<class_2960>> map = new LinkedHashMap<>();

		for (String registryId : mainNbt.method_10541()) {
			Object2IntMap<class_2960> idMap = new Object2IntLinkedOpenHashMap<>();
			class_2487 idNbt = mainNbt.method_10562(registryId);

			for (String id : idNbt.method_10541()) {
				idMap.put(class_2960.method_60654(id), idNbt.method_10550(id));
			}

			map.put(class_2960.method_60654(registryId), idMap);
		}

		return map;
	}

	public static class_2487 toNbt(Map<class_2960, Object2IntMap<class_2960>> map) {
		class_2487 mainNbt = new class_2487();

		map.forEach((registryId, idMap) -> {
			class_2487 registryNbt = new class_2487();

			for (Object2IntMap.Entry<class_2960> idPair : idMap.object2IntEntrySet()) {
				registryNbt.method_10569(idPair.getKey().toString(), idPair.getIntValue());
			}

			mainNbt.method_10566(registryId.toString(), registryNbt);
		});

		class_2487 nbt = new class_2487();
		nbt.method_10569("version", VERSION);
		nbt.method_10566("registries", mainNbt);
		return nbt;
	}
}
