/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.registry.sync;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class RemapStateImpl<T> implements RegistryIdRemapCallback.RemapState<T> {
	private final Int2IntMap rawIdChangeMap;
	private final Int2ObjectMap<class_2960> oldIdMap;
	private final Int2ObjectMap<class_2960> newIdMap;

	public RemapStateImpl(class_2378<T> registry, Int2ObjectMap<class_2960> oldIdMap, Int2IntMap rawIdChangeMap) {
		this.rawIdChangeMap = rawIdChangeMap;
		this.oldIdMap = oldIdMap;
		this.newIdMap = new Int2ObjectOpenHashMap<>();

		for (Int2IntMap.Entry entry : rawIdChangeMap.int2IntEntrySet()) {
			class_2960 id = registry.method_10221(registry.method_10200(entry.getIntValue()));
			newIdMap.put(entry.getIntValue(), id);
		}
	}

	@Override
	public Int2IntMap getRawIdChangeMap() {
		return rawIdChangeMap;
	}

	@Override
	public class_2960 getIdFromOld(int oldRawId) {
		return oldIdMap.get(oldRawId);
	}

	@Override
	public class_2960 getIdFromNew(int newRawId) {
		return newIdMap.get(newRawId);
	}
}
