/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry.sync;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.registry.FabricRegistry;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.fabricmc.fabric.impl.registry.sync.ListenableRegistry;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemapStateImpl;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9248;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2370.class})
public abstract class SimpleRegistryMixin<T>
implements class_2385<T>,
RemappableRegistry,
ListenableRegistry<T>,
FabricRegistry {
    @Unique
    private static final Set<String> VANILLA_NAMESPACES = Set.of("minecraft", "brigadier");
    @Shadow
    @Final
    private ObjectList<class_6880.class_6883<T>> field_26682;
    @Shadow
    @Final
    private Reference2IntMap<T> field_26683;
    @Shadow
    @Final
    private Map<class_2960, class_6880.class_6883<T>> field_11107;
    @Shadow
    @Final
    private Map<class_5321<T>, class_6880.class_6883<T>> field_25067;
    @Unique
    private static final Logger FABRIC_LOGGER = LoggerFactory.getLogger(SimpleRegistryMixin.class);
    @Unique
    private Event<RegistryEntryAddedCallback<T>> fabric_addObjectEvent;
    @Unique
    private Event<RegistryIdRemapCallback<T>> fabric_postRemapEvent;
    @Unique
    private Object2IntMap<class_2960> fabric_prevIndexedEntries;
    @Unique
    private BiMap<class_2960, class_6880.class_6883<T>> fabric_prevEntries;
    @Unique
    private Map<class_2960, class_2960> aliases = new HashMap<class_2960, class_2960>();
    @Shadow
    @Final
    private class_5321<? extends class_2378<T>> field_41126;

    @Shadow
    public abstract Optional<class_5321<T>> method_29113(T var1);

    @Shadow
    @Nullable
    public abstract T method_63535(@Nullable class_2960 var1);

    @Shadow
    public abstract class_5321<? extends class_2378<T>> method_46765();

    @Shadow
    public abstract boolean method_10250(class_2960 var1);

    @Shadow
    public abstract String toString();

    @Shadow
    protected abstract void method_45939();

    @Override
    public Event<RegistryEntryAddedCallback<T>> fabric_getAddObjectEvent() {
        return this.fabric_addObjectEvent;
    }

    @Override
    public Event<RegistryIdRemapCallback<T>> fabric_getRemapEvent() {
        return this.fabric_postRemapEvent;
    }

    @Inject(method={"<init>(Lnet/minecraft/class_5321;Lcom/mojang/serialization/Lifecycle;Z)V"}, at={@At(value="RETURN")})
    private void init(class_5321<?> key, Lifecycle lifecycle, boolean intrusive, CallbackInfo ci) {
        this.fabric_addObjectEvent = EventFactory.createArrayBacked(RegistryEntryAddedCallback.class, callbacks -> (rawId, id, object) -> {
            for (RegistryEntryAddedCallback callback : callbacks) {
                callback.onEntryAdded(rawId, id, object);
            }
        });
        this.fabric_addObjectEvent.register((rawId, id, object) -> {
            if (this.aliases.containsKey(id)) {
                throw new IllegalArgumentException("Tried registering %s to registry %s, but it is already an alias (for %s)".formatted(id, this.field_41126, this.aliases.get(id)));
            }
        });
        this.fabric_postRemapEvent = EventFactory.createArrayBacked(RegistryIdRemapCallback.class, callbacks -> a -> {
            for (RegistryIdRemapCallback callback : callbacks) {
                callback.onRemap(a);
            }
        });
    }

    @Unique
    private void onChange(class_5321<T> registryKey) {
        RegistryAttributeHolder holder;
        if (!(!RegistrySyncManager.postBootstrap && VANILLA_NAMESPACES.contains(registryKey.method_29177().method_12836()) || (holder = RegistryAttributeHolder.get(this.method_46765())).hasAttribute(RegistryAttribute.MODDED))) {
            class_2960 id = this.method_46765().method_29177();
            FABRIC_LOGGER.debug("Registry {} has been marked as modded, registry entry {} was changed", (Object)id, (Object)registryKey.method_29177());
            RegistryAttributeHolder.get(this.method_46765()).addAttribute(RegistryAttribute.MODDED);
        }
    }

    @Inject(method={"method_10272(Lnet/minecraft/class_5321;Ljava/lang/Object;Lnet/minecraft/class_9248;)Lnet/minecraft/class_6880$class_6883;"}, at={@At(value="RETURN")})
    private void set(class_5321<T> key, T entry, class_9248 arg, CallbackInfoReturnable<class_6880.class_6883<T>> info) {
        ((class_6880.class_6883)info.getReturnValue()).method_45918(entry);
        ((RegistryEntryAddedCallback)this.fabric_addObjectEvent.invoker()).onEntryAdded(this.field_26683.getInt(entry), key.method_29177(), entry);
        this.onChange(key);
    }

    @Override
    public void remap(Object2IntMap<class_2960> remoteIndexedEntries, RemappableRegistry.RemapMode mode) throws RemapException {
        class_2960 id2;
        Iterator o;
        Object strings;
        switch (mode) {
            case AUTHORITATIVE: {
                break;
            }
            case REMOTE: {
                Object remoteId2;
                strings = null;
                for (Object remoteId2 : remoteIndexedEntries.keySet()) {
                    if (this.method_10250((class_2960)remoteId2)) continue;
                    if (strings == null) {
                        strings = new ArrayList();
                    }
                    strings.add(" - " + String.valueOf(remoteId2));
                }
                if (strings == null) break;
                StringBuilder builder = new StringBuilder("Received ID map for " + String.valueOf(this.method_46765()) + " contains IDs unknown to the receiver!");
                remoteId2 = strings.iterator();
                while (remoteId2.hasNext()) {
                    String s = (String)remoteId2.next();
                    builder.append('\n').append(s);
                }
                throw new RemapException(builder.toString());
            }
        }
        if (this.fabric_prevIndexedEntries == null) {
            this.fabric_prevIndexedEntries = new Object2IntOpenHashMap();
            this.fabric_prevEntries = HashBiMap.create(this.field_11107);
            strings = this.iterator();
            while (strings.hasNext()) {
                o = strings.next();
                this.fabric_prevIndexedEntries.put((Object)this.method_10221(o), this.method_10206(o));
            }
        }
        Int2ObjectOpenHashMap oldIdMap = new Int2ObjectOpenHashMap();
        o = this.iterator();
        while (o.hasNext()) {
            Object o2 = o.next();
            oldIdMap.put(this.method_10206(o2), (Object)this.method_10221(o2));
        }
        switch (mode) {
            case AUTHORITATIVE: {
                int maxValue = 0;
                Object2IntOpenHashMap oldRemoteIndexedEntries = remoteIndexedEntries;
                remoteIndexedEntries = new Object2IntOpenHashMap();
                for (class_2960 id2 : oldRemoteIndexedEntries.keySet()) {
                    int v = oldRemoteIndexedEntries.getInt((Object)id2);
                    remoteIndexedEntries.put((Object)id2, v);
                    if (v <= maxValue) continue;
                    maxValue = v;
                }
                for (class_2960 id2 : this.method_10235()) {
                    if (remoteIndexedEntries.containsKey((Object)id2)) continue;
                    FABRIC_LOGGER.warn("Adding " + String.valueOf(id2) + " to saved/remote registry.");
                    remoteIndexedEntries.put((Object)id2, ++maxValue);
                }
                break;
            }
            case REMOTE: {
                int maxId = -1;
                for (class_2960 id3 : this.method_10235()) {
                    if (remoteIndexedEntries.containsKey((Object)id3)) continue;
                    if (maxId < 0) {
                        id2 = remoteIndexedEntries.values().iterator();
                        while (id2.hasNext()) {
                            int value = (Integer)id2.next();
                            if (value <= maxId) continue;
                            maxId = value;
                        }
                    }
                    if (maxId < 0) {
                        throw new RemapException("Failed to assign new id to client only registry entry");
                    }
                    FABRIC_LOGGER.debug("An ID for {} was not sent by the server, assuming client only registry entry and assigning a new id ({}) in {}", new Object[]{id3.toString(), ++maxId, this.method_46765().method_29177().toString()});
                    remoteIndexedEntries.put((Object)id3, maxId);
                }
                break;
            }
        }
        Int2IntOpenHashMap idMap = new Int2IntOpenHashMap();
        for (int i = 0; i < this.field_26682.size(); ++i) {
            class_6880.class_6883 reference = (class_6880.class_6883)this.field_26682.get(i);
            if (reference == null) {
                throw new RemapException("Unused id " + i + " in registry " + String.valueOf(this.method_46765().method_29177()));
            }
            id2 = reference.method_40237().method_29177();
            if (!remoteIndexedEntries.containsKey((Object)id2)) continue;
            idMap.put(i, remoteIndexedEntries.getInt((Object)id2));
        }
        this.field_26682.clear();
        this.field_26683.clear();
        ArrayList<class_2960> orderedRemoteEntries = new ArrayList<class_2960>((Collection<class_2960>)remoteIndexedEntries.keySet());
        orderedRemoteEntries.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)remoteIndexedEntries).getInt(arg_0)));
        for (class_2960 identifier : orderedRemoteEntries) {
            int id4 = remoteIndexedEntries.getInt((Object)identifier);
            class_6880.class_6883<T> object = this.field_11107.get(identifier);
            if (object == null) {
                if (mode != RemappableRegistry.RemapMode.AUTHORITATIVE) {
                    throw new RemapException(String.valueOf(identifier) + " missing from registry, but requested!");
                }
                FABRIC_LOGGER.warn(String.valueOf(identifier) + " missing from registry, but requested!");
                continue;
            }
            this.field_26682.size(Math.max(this.field_26682.size(), id4 + 1));
            assert (this.field_26682.get(id4) == null);
            this.field_26682.set(id4, object);
            this.field_26683.put(object.comp_349(), id4);
        }
        ((RegistryIdRemapCallback)this.fabric_getRemapEvent().invoker()).onRemap(new RemapStateImpl(this, (Int2ObjectMap<class_2960>)oldIdMap, (Int2IntMap)idMap));
    }

    @Override
    public void unmap() throws RemapException {
        if (this.fabric_prevIndexedEntries != null) {
            ArrayList<class_2960> addedIds = new ArrayList<class_2960>();
            for (class_2960 id : this.fabric_prevEntries.keySet()) {
                if (this.field_11107.containsKey(id)) continue;
                assert (this.fabric_prevIndexedEntries.containsKey((Object)id));
                addedIds.add(id);
            }
            this.field_11107.clear();
            this.field_25067.clear();
            this.field_11107.putAll((Map<class_2960, class_6880.class_6883<T>>)this.fabric_prevEntries);
            for (Map.Entry entry : this.fabric_prevEntries.entrySet()) {
                class_5321 entryKey = class_5321.method_29179(this.method_46765(), (class_2960)((class_2960)entry.getKey()));
                this.field_25067.put(entryKey, (class_6880.class_6883)entry.getValue());
            }
            this.remap(this.fabric_prevIndexedEntries, RemappableRegistry.RemapMode.AUTHORITATIVE);
            for (class_2960 id : addedIds) {
                ((RegistryEntryAddedCallback)this.fabric_getAddObjectEvent().invoker()).onEntryAdded(this.field_26683.getInt(this.field_11107.get(id)), id, this.method_63535(id));
            }
            this.fabric_prevIndexedEntries = null;
            this.fabric_prevEntries = null;
        }
    }

    @Override
    public void addAlias(class_2960 old, class_2960 newId) {
        Objects.requireNonNull(old, "alias cannot be null");
        Objects.requireNonNull(newId, "aliased id cannot be null");
        if (this.aliases.containsKey(old)) {
            throw new IllegalArgumentException("Tried adding %s as an alias for %s, but it is already an alias (for %s) in registry %s".formatted(old, newId, this.aliases.get(old), this.field_41126));
        }
        if (this.field_11107.containsKey(old)) {
            throw new IllegalArgumentException("Tried adding %s as an alias, but it is already present in registry %s".formatted(old, this.field_41126));
        }
        if (old.equals((Object)this.aliases.get(newId))) {
            throw new IllegalArgumentException("Making %1$s an alias of %2$s would create a cycle, as %2$s is already an alias of %1$s (registry %3$s)".formatted(old, newId, this.field_41126));
        }
        if (!this.field_11107.containsKey(newId)) {
            FABRIC_LOGGER.warn("Adding {} as an alias for {}, but the latter doesn't exist in registry {}", new Object[]{old, newId, this.field_41126});
        }
        this.method_45939();
        class_2960 deepest = this.aliases.getOrDefault(newId, newId);
        for (Map.Entry<class_2960, class_2960> entry : this.aliases.entrySet()) {
            if (!old.equals((Object)entry.getValue())) continue;
            entry.setValue(deepest);
        }
        this.aliases.put(old, deepest);
        FABRIC_LOGGER.debug("Adding alias {} for {} in registry {}", new Object[]{old, newId, this.field_41126});
    }

    @ModifyVariable(method={"method_10223(Lnet/minecraft/class_2960;)Ljava/util/Optional;", "method_63535(Lnet/minecraft/class_2960;)Ljava/lang/Object;", "method_10250(Lnet/minecraft/class_2960;)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private class_2960 aliasIdentifierParameter(class_2960 original) {
        return this.aliases.getOrDefault(original, original);
    }

    @ModifyVariable(method={"method_29107(Lnet/minecraft/class_5321;)Ljava/lang/Object;", "method_46746(Lnet/minecraft/class_5321;)Ljava/util/Optional;", "method_44298(Lnet/minecraft/class_5321;)Lnet/minecraft/class_6880$class_6883;", "method_35842(Lnet/minecraft/class_5321;)Z", "method_57058(Lnet/minecraft/class_5321;)Ljava/util/Optional;"}, at=@At(value="HEAD"), argsOnly=true)
    private class_5321<T> aliasRegistryKeyParameter(class_5321<T> original) {
        if (original == null) {
            return null;
        }
        class_2960 aliased = this.aliases.get(original.method_29177());
        return aliased == null ? original : class_5321.method_29179((class_5321)original.method_58273(), (class_2960)aliased);
    }
}

