/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.registry.sync.trackers.vanilla;

import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public final class BlockItemTracker implements RegistryEntryAddedCallback<class_1792> {
	private BlockItemTracker() { }

	public static void register(class_2378<class_1792> registry) {
		BlockItemTracker tracker = new BlockItemTracker();
		RegistryEntryAddedCallback.event(registry).register(tracker);
	}

	@Override
	public void onEntryAdded(int rawId, class_2960 id, class_1792 object) {
		if (object instanceof class_1747) {
			((class_1747) object).method_7713(class_1792.field_8003, object);
		}
	}
}
