/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.fabricmc.fabric.impl.registry.sync.packet.DirectRegistryPacketHandler;
import net.minecraft.class_11560;
import net.minecraft.class_124;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrySyncManager {
    public static final boolean DEBUG = Boolean.getBoolean("fabric.registry.debug");
    public static final DirectRegistryPacketHandler DIRECT_PACKET_HANDLER = new DirectRegistryPacketHandler();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FabricRegistrySync");
    private static final boolean DEBUG_WRITE_REGISTRY_DATA = Boolean.getBoolean("fabric.registry.debug.writeContentsAsCsv");
    public static boolean postBootstrap = false;

    private RegistrySyncManager() {
    }

    public static void configureClient(class_8610 handler, MinecraftServer server) {
        if (!DEBUG && server.method_19466(new class_11560(handler.method_52404()))) {
            return;
        }
        Map<class_2960, Object2IntMap<class_2960>> map = RegistrySyncManager.createAndPopulateRegistryMap();
        if (map == null) {
            return;
        }
        if (!ServerConfigurationNetworking.canSend((class_8610)handler, DIRECT_PACKET_HANDLER.getPacketId())) {
            if (RegistrySyncManager.areAllRegistriesOptional(map)) {
                return;
            }
            class_2561 message = RegistrySyncManager.getIncompatibleClientText(ServerNetworkingImpl.getAddon((class_8610)handler).getClientBrand(), map);
            handler.method_52396(message);
            return;
        }
        handler.addTask((class_8605)new SyncConfigurationTask(handler, map));
    }

    private static class_2561 getIncompatibleClientText(@Nullable String brand, Map<class_2960, Object2IntMap<class_2960>> map) {
        String string = brand;
        int n = 0;
        String brandText = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"fabric"}, (Object)string, n)) {
            case 0 -> "Fabric API";
            default -> "Fabric Loader and Fabric API";
        };
        int toDisplay = 4;
        List<String> namespaces = map.values().stream().map(Object2IntMap::keySet).flatMap(Collection::stream).map(class_2960::method_12836).filter(s -> !s.equals("minecraft")).distinct().sorted().toList();
        class_5250 text = class_2561.method_43470((String)"The following registry entry namespaces may be related:\n\n");
        for (int i = 0; i < Math.min(namespaces.size(), 4); ++i) {
            text = text.method_10852((class_2561)class_2561.method_43470((String)namespaces.get(i)).method_27692(class_124.field_1054));
            text = text.method_10852(class_5244.field_33849);
        }
        if (namespaces.size() > 4) {
            text = text.method_10852((class_2561)class_2561.method_43470((String)"And %d more...".formatted(namespaces.size() - 4)));
        }
        return class_2561.method_43470((String)"This server requires ").method_10852((class_2561)class_2561.method_43470((String)brandText).method_27692(class_124.field_1060)).method_27693(" installed on your client!").method_10852(class_5244.field_33849).method_10852((class_2561)text).method_10852(class_5244.field_33849).method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43470((String)"Contact the server's administrator for more information!").method_27692(class_124.field_1065));
    }

    private static boolean areAllRegistriesOptional(Map<class_2960, Object2IntMap<class_2960>> map) {
        return map.keySet().stream().map(arg_0 -> ((class_2378)class_7923.field_41167).method_63535(arg_0)).filter(Objects::nonNull).map(RegistryAttributeHolder::get).allMatch(attributes -> attributes.hasAttribute(RegistryAttribute.OPTIONAL));
    }

    @Nullable
    public static Map<class_2960, Object2IntMap<class_2960>> createAndPopulateRegistryMap() {
        LinkedHashMap<class_2960, Object2IntMap<class_2960>> map = new LinkedHashMap<class_2960, Object2IntMap<class_2960>>();
        for (class_2960 registryId : class_7923.field_41167.method_10235()) {
            RegistryAttributeHolder attributeHolder;
            class_2378 registry = (class_2378)class_7923.field_41167.method_63535(registryId);
            if (DEBUG_WRITE_REGISTRY_DATA) {
                File location = new File(".fabric" + File.separatorChar + "debug" + File.separatorChar + "registry");
                boolean c = true;
                if (!location.exists() && !location.mkdirs()) {
                    LOGGER.warn("[fabric-registry-sync debug] Could not create " + location.getAbsolutePath() + " directory!");
                    c = false;
                }
                if (c && registry != null) {
                    File file = new File(location, registryId.toString().replace(':', '.').replace('/', '.') + ".csv");
                    try (FileOutputStream stream = new FileOutputStream(file);){
                        StringBuilder builder = new StringBuilder("Raw ID,String ID,Class Type\n");
                        for (Object o : registry) {
                            String classType = o == null ? "null" : o.getClass().getName();
                            class_2960 id = registry.method_10221(o);
                            if (id == null) continue;
                            int rawId = registry.method_10206(o);
                            String stringId = id.toString();
                            builder.append("\"").append(rawId).append("\",\"").append(stringId).append("\",\"").append(classType).append("\"\n");
                        }
                        stream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
                    }
                    catch (IOException e) {
                        LOGGER.warn("[fabric-registry-sync debug] Could not write to " + file.getAbsolutePath() + "!", (Throwable)e);
                    }
                }
            }
            if (!(attributeHolder = RegistryAttributeHolder.get(registry.method_46765())).hasAttribute(RegistryAttribute.SYNCED)) {
                LOGGER.debug("Not syncing registry: {}", (Object)registryId);
                continue;
            }
            if (!attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
                LOGGER.debug("Skipping un-modded registry: " + String.valueOf(registryId));
                continue;
            }
            LOGGER.debug("Syncing registry: " + String.valueOf(registryId));
            if (!(registry instanceof RemappableRegistry)) continue;
            Object2IntLinkedOpenHashMap idMap = new Object2IntLinkedOpenHashMap();
            IntOpenHashSet rawIdsFound = DEBUG ? new IntOpenHashSet() : null;
            for (Object o : registry) {
                class_2960 id = registry.method_10221(o);
                if (id == null) continue;
                int rawId = registry.method_10206(o);
                if (DEBUG) {
                    if (registry.method_63535(id) != o) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + String.valueOf(registryId) + ": object " + String.valueOf(o) + " -> string ID " + String.valueOf(id) + " -> object " + String.valueOf(registry.method_63535(id)) + "!");
                    }
                    if (registry.method_10200(rawId) != o) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + String.valueOf(registryId) + ": object " + String.valueOf(o) + " -> integer ID " + rawId + " -> object " + String.valueOf(registry.method_10200(rawId)) + "!");
                    }
                    if (!rawIdsFound.add(rawId)) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + String.valueOf(registryId) + ": multiple objects hold the raw ID " + rawId + " (this one is " + String.valueOf(id) + ")");
                    }
                }
                idMap.put((Object)id, rawId);
            }
            map.put(registryId, (Object2IntMap<class_2960>)idMap);
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public static void bootstrapRegistries() {
        postBootstrap = true;
    }

    public record SyncConfigurationTask(class_8610 handler, Map<class_2960, Object2IntMap<class_2960>> map) implements class_8605
    {
        public static final class_8605.class_8606 KEY = new class_8605.class_8606("fabric:registry/sync");

        public void method_52376(Consumer<class_2596<?>> sender) {
            DIRECT_PACKET_HANDLER.sendPacket(payload -> this.handler.method_14364(ServerConfigurationNetworking.createS2CPacket((class_8710)payload)), this.map);
        }

        public class_8605.class_8606 method_52375() {
            return KEY;
        }
    }
}

