/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.registry.sync;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

import com.mojang.serialization.Codec;
import org.jetbrains.annotations.Unmodifiable;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7655;
import net.minecraft.class_7782;

public final class DynamicRegistriesImpl {
	private static final List<class_7655.class_7657<?>> DYNAMIC_REGISTRIES = new ArrayList<>(class_7655.field_39968);
	public static final Set<class_5321<?>> FABRIC_DYNAMIC_REGISTRY_KEYS = new HashSet<>();
	public static final Set<class_5321<? extends class_2378<?>>> DYNAMIC_REGISTRY_KEYS = new HashSet<>();
	public static final Set<class_5321<? extends class_2378<?>>> SKIP_EMPTY_SYNC_REGISTRIES = new HashSet<>();

	static {
		for (class_7655.class_7657<?> vanillaEntry : class_7655.field_39968) {
			DYNAMIC_REGISTRY_KEYS.add(vanillaEntry.comp_985());
		}
	}

	private DynamicRegistriesImpl() {
	}

	public static @Unmodifiable List<class_7655.class_7657<?>> getDynamicRegistries() {
		return List.copyOf(DYNAMIC_REGISTRIES);
	}

	public static <T> class_7655.class_7657<T> register(class_5321<? extends class_2378<T>> key, Codec<T> serverCodec) {
		Objects.requireNonNull(key, "Registry key cannot be null");
		Objects.requireNonNull(serverCodec, "Server codec cannot be null");

		if (!DYNAMIC_REGISTRY_KEYS.add(key)) {
			throw new IllegalArgumentException("Dynamic registry " + key + " has already been registered!");
		}

		var entry = new class_7655.class_7657<>(key, serverCodec, false);
		DYNAMIC_REGISTRIES.add(entry);
		FABRIC_DYNAMIC_REGISTRY_KEYS.add(key);
		return entry;
	}

	public static <T> void addSyncedRegistry(class_5321<? extends class_2378<T>> key, Codec<T> clientCodec, DynamicRegistries.SyncOption... options) {
		Objects.requireNonNull(key, "Registry key cannot be null");
		Objects.requireNonNull(clientCodec, "Client codec cannot be null");
		Objects.requireNonNull(options, "Options cannot be null");

		if (!(class_7655.field_48709 instanceof ArrayList<class_7655.class_7657<?>>)) {
			class_7655.field_48709 = new ArrayList<>(class_7655.field_48709);
		}

		class_7655.field_48709.add(new class_7655.class_7657<>(key, clientCodec, false));

		if (!(class_7782.field_48771 instanceof HashSet<class_5321<? extends class_2378<?>>>)) {
			class_7782.field_48771 = new HashSet<>(class_7782.field_48771);
		}

		class_7782.field_48771.add(key);

		for (DynamicRegistries.SyncOption option : options) {
			if (option == DynamicRegistries.SyncOption.SKIP_WHEN_EMPTY) {
				SKIP_EMPTY_SYNC_REGISTRIES.add(key);
			}
		}
	}
}
