/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.packet;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.Deflater;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import org.jspecify.annotations.Nullable;

public abstract class RegistryPacketHandler<T extends RegistrySyncPayload> {
    private int rawBufSize = 0;
    private int deflatedBufSize = 0;

    public abstract class_8710.class_9154<T> getPacketId();

    public abstract void sendPacket(Consumer<T> var1, Map<class_2960, Object2IntMap<class_2960>> var2);

    public abstract void receivePayload(T var1);

    public abstract int getTotalPacketReceived();

    public abstract boolean isPacketFinished();

    public abstract @Nullable SyncedPacketData getSyncedPacketData();

    protected final void computeBufSize(class_2540 buf) {
        if (!RegistrySyncManager.DEBUG) {
            return;
        }
        byte[] deflateBuffer = new byte[8192];
        ByteBuf byteBuf = buf.copy();
        Deflater deflater = new Deflater();
        int i = byteBuf.readableBytes();
        class_2540 deflatedBuf = PacketByteBufs.create();
        if (i < 256) {
            deflatedBuf.method_10804(0);
            deflatedBuf.method_52975(byteBuf);
        } else {
            byte[] bs = new byte[i];
            byteBuf.readBytes(bs);
            deflatedBuf.method_10804(bs.length);
            deflater.setInput(bs, 0, i);
            deflater.finish();
            while (!deflater.finished()) {
                int j = deflater.deflate(deflateBuffer);
                deflatedBuf.method_52980(deflateBuffer, 0, j);
            }
            deflater.reset();
        }
        this.rawBufSize = buf.readableBytes();
        this.deflatedBufSize = deflatedBuf.readableBytes();
    }

    public final int getRawBufSize() {
        return this.rawBufSize;
    }

    public final int getDeflatedBufSize() {
        return this.deflatedBufSize;
    }

    public record SyncedPacketData(Map<class_2960, Object2IntMap<class_2960>> idMap, Map<class_2960, EnumSet<RegistryAttribute>> attributes) {
    }

    public static interface RegistrySyncPayload
    extends class_8710 {
    }
}

