/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.registry.sync;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.fabricmc.fabric.impl.registry.sync.packet.RegistryPacketHandler;
import net.minecraft.class_124;
import net.minecraft.class_1255;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class ClientRegistrySyncHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientRegistrySyncHandler.class);

    private ClientRegistrySyncHandler() {
    }

    public static <T extends RegistryPacketHandler.RegistrySyncPayload> CompletableFuture<Boolean> receivePacket(class_1255<?> executor, RegistryPacketHandler<T> handler, T payload, boolean accept) {
        handler.receivePayload(payload);
        if (!handler.isPacketFinished()) {
            return CompletableFuture.completedFuture(false);
        }
        if (RegistrySyncManager.DEBUG) {
            String handlerName = handler.getClass().getSimpleName();
            LOGGER.info("{} total packet: {}", (Object)handlerName, (Object)handler.getTotalPacketReceived());
            LOGGER.info("{} raw size: {}", (Object)handlerName, (Object)handler.getRawBufSize());
            LOGGER.info("{} deflated size: {}", (Object)handlerName, (Object)handler.getDeflatedBufSize());
        }
        RegistryPacketHandler.SyncedPacketData data = handler.getSyncedPacketData();
        if (!accept) {
            return CompletableFuture.completedFuture(true);
        }
        return executor.method_5385(() -> {
            if (data == null) {
                throw new CompletionException(new RemapException("Received null map in sync packet!"));
            }
            try {
                ClientRegistrySyncHandler.apply(data);
                return true;
            }
            catch (RemapException e) {
                throw new CompletionException(e);
            }
        });
    }

    public static void apply(RegistryPacketHandler.SyncedPacketData data) throws RemapException {
        ClientRegistrySyncHandler.checkRemoteRemap(data);
        for (Map.Entry<class_2960, Object2IntMap<class_2960>> entry : data.idMap().entrySet()) {
            class_2960 registryId = entry.getKey();
            class_2378 registry = (class_2378)class_7923.field_41167.method_63535(registryId);
            if (registry == null && ClientRegistrySyncHandler.isRegistryOptional(registryId, data)) {
                LOGGER.info("Received registry data for unknown optional registry: {}", (Object)registryId);
                continue;
            }
            if (registry instanceof RemappableRegistry) {
                RemappableRegistry remappableRegistry = (RemappableRegistry)registry;
                remappableRegistry.remap(entry.getValue(), RemappableRegistry.RemapMode.REMOTE);
                return;
            }
            throw new RemapException("Registry " + String.valueOf(registryId) + " is not remappable");
        }
    }

    @VisibleForTesting
    public static void checkRemoteRemap(RegistryPacketHandler.SyncedPacketData data) throws RemapException {
        Map<class_2960, Object2IntMap<class_2960>> map = data.idMap();
        ArrayList<class_2960> missingRegistries = new ArrayList<class_2960>();
        HashMap<class_2960, List<class_2960>> missingEntries = new HashMap<class_2960, List<class_2960>>();
        for (class_2960 class_29602 : map.keySet()) {
            Object2IntMap<class_2960> remoteRegistry = map.get(class_29602);
            class_2378 registry = (class_2378)class_7923.field_41167.method_63535(class_29602);
            if (registry == null) {
                if (ClientRegistrySyncHandler.isRegistryOptional(class_29602, data)) continue;
                missingRegistries.add(class_29602);
                continue;
            }
            for (class_2960 remoteId : remoteRegistry.keySet()) {
                if (registry.method_10250(remoteId)) continue;
                missingEntries.computeIfAbsent(class_29602, i -> new ArrayList()).add(remoteId);
            }
        }
        if (missingRegistries.isEmpty() && missingEntries.isEmpty()) {
            return;
        }
        if (!missingRegistries.isEmpty()) {
            LOGGER.error("Received unknown remote registries from server");
            for (class_2960 class_29603 : missingRegistries) {
                LOGGER.error("Received unknown remote registry ({}) from server", (Object)class_29603);
            }
        }
        if (!missingEntries.isEmpty()) {
            LOGGER.error("Received unknown remote registry entries from server");
            for (Map.Entry entry : missingEntries.entrySet()) {
                for (class_2960 identifier : (List)entry.getValue()) {
                    LOGGER.error("Registry entry ({}) is missing from local registry ({})", (Object)identifier, entry.getKey());
                }
            }
        }
        if (!missingRegistries.isEmpty()) {
            throw new RemapException(ClientRegistrySyncHandler.missingRegistriesError(missingRegistries));
        }
        throw new RemapException(ClientRegistrySyncHandler.missingEntriesError(missingEntries));
    }

    private static class_2561 missingRegistriesError(List<class_2960> missingRegistries) {
        class_5250 text = class_2561.method_43473();
        int count = missingRegistries.size();
        text = count == 1 ? text.method_10852((class_2561)class_2561.method_43471((String)"fabric-registry-sync-v0.unknown-registry.title.singular")) : text.method_10852((class_2561)class_2561.method_43469((String)"fabric-registry-sync-v0.unknown-registry.title.plural", (Object[])new Object[]{count}));
        text = text.method_10852((class_2561)class_2561.method_43471((String)"fabric-registry-sync-v0.unknown-registry.subtitle.1").method_27692(class_124.field_1060));
        text = text.method_10852((class_2561)class_2561.method_43471((String)"fabric-registry-sync-v0.unknown-registry.subtitle.2"));
        int toDisplay = 4;
        for (int i = 0; i < Math.min(missingRegistries.size(), 4); ++i) {
            text = text.method_10852((class_2561)class_2561.method_43470((String)missingRegistries.get(i).toString()).method_27692(class_124.field_1054));
            text = text.method_10852(class_5244.field_33849);
        }
        if (missingRegistries.size() > 4) {
            text = text.method_10852((class_2561)class_2561.method_43469((String)"fabric-registry-sync-v0.unknown-registry.footer", (Object[])new Object[]{missingRegistries.size() - 4}));
        }
        return text;
    }

    private static class_2561 missingEntriesError(Map<class_2960, List<class_2960>> missingEntries) {
        class_5250 text = class_2561.method_43473();
        int count = missingEntries.values().stream().mapToInt(List::size).sum();
        text = count == 1 ? text.method_10852((class_2561)class_2561.method_43471((String)"fabric-registry-sync-v0.unknown-remote.title.singular")) : text.method_10852((class_2561)class_2561.method_43469((String)"fabric-registry-sync-v0.unknown-remote.title.plural", (Object[])new Object[]{count}));
        text = text.method_10852((class_2561)class_2561.method_43471((String)"fabric-registry-sync-v0.unknown-remote.subtitle.1").method_27692(class_124.field_1060));
        text = text.method_10852((class_2561)class_2561.method_43471((String)"fabric-registry-sync-v0.unknown-remote.subtitle.2"));
        int toDisplay = 4;
        List<String> namespaces = missingEntries.values().stream().flatMap(Collection::stream).map(class_2960::method_12836).distinct().sorted().toList();
        for (int i = 0; i < Math.min(namespaces.size(), 4); ++i) {
            text = text.method_10852((class_2561)class_2561.method_43470((String)namespaces.get(i)).method_27692(class_124.field_1054));
            text = text.method_10852(class_5244.field_33849);
        }
        if (namespaces.size() > 4) {
            text = text.method_10852((class_2561)class_2561.method_43469((String)"fabric-registry-sync-v0.unknown-remote.footer", (Object[])new Object[]{namespaces.size() - 4}));
        }
        return text;
    }

    private static boolean isRegistryOptional(class_2960 registryId, RegistryPacketHandler.SyncedPacketData data) {
        EnumSet<RegistryAttribute> registryAttributes = data.attributes().get(registryId);
        return registryAttributes.contains((Object)RegistryAttribute.OPTIONAL);
    }
}

