/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.impl.registry.RemapException;
import net.fabricmc.fabric.impl.registry.RemappableRegistry;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;

public final class RegistrySyncManager {
    public static final class_2960 ID = new class_2960("fabric", "registry/sync");
    private static final Set<class_2960> REGISTRY_BLACKLIST = ImmutableSet.of();
    private static final Set<class_2960> REGISTRY_BLACKLIST_NETWORK = ImmutableSet.of();

    private RegistrySyncManager() {
    }

    public static class_2596<?> createPacket() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10794(RegistrySyncManager.toTag(true));
        return ServerSidePacketRegistry.INSTANCE.toPacket(ID, buf);
    }

    public static void receivePacket(PacketContext context, class_2540 buf, boolean accept, Consumer<Exception> errorHandler) {
        class_2487 compound = buf.method_10798();
        if (accept) {
            try {
                context.getTaskQueue().method_5385(() -> {
                    if (compound == null) {
                        errorHandler.accept(new RemapException("Received null compound tag in sync packet!"));
                        return null;
                    }
                    try {
                        RegistrySyncManager.apply(compound, RemappableRegistry.RemapMode.REMOTE);
                    }
                    catch (RemapException e) {
                        errorHandler.accept(e);
                    }
                    return null;
                }).get(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                errorHandler.accept(e);
            }
        }
    }

    public static class_2487 toTag(boolean isClientSync) {
        class_2487 mainTag = new class_2487();
        for (class_2960 registryId : class_2378.field_11144.method_10235()) {
            class_2385 registry;
            if (REGISTRY_BLACKLIST.contains(registryId) || isClientSync && REGISTRY_BLACKLIST_NETWORK.contains(registryId) || !((registry = (class_2385)class_2378.field_11144.method_10223(registryId)) instanceof class_2370) || !(registry instanceof RemappableRegistry)) continue;
            class_2487 registryTag = new class_2487();
            for (class_2960 identifier : registry.method_10235()) {
                registryTag.method_10569(identifier.toString(), registry.method_10249(registry.method_10223(identifier)));
            }
            mainTag.method_10566(registryId.toString(), (class_2520)registryTag);
        }
        class_2487 tag = new class_2487();
        tag.method_10569("version", 1);
        tag.method_10566("registries", (class_2520)mainTag);
        return tag;
    }

    public static void apply(class_2487 tag, RemappableRegistry.RemapMode mode) throws RemapException {
        class_2487 mainTag = tag.method_10562("registries");
        for (class_2960 registryId : class_2378.field_11144.method_10235()) {
            if (!mainTag.method_10545(registryId.toString())) continue;
            class_2487 registryTag = mainTag.method_10562(registryId.toString());
            class_2385 registry = (class_2385)class_2378.field_11144.method_10223(registryId);
            if (!(registry instanceof class_2370) || !(registry instanceof RemappableRegistry)) continue;
            Object2IntOpenHashMap idMap = new Object2IntOpenHashMap();
            for (String key : registryTag.method_10541()) {
                idMap.put((Object)new class_2960(key), registryTag.method_10550(key));
            }
            ((RemappableRegistry)registry).remap(registryId.toString(), (Object2IntMap<class_2960>)idMap, mode);
        }
    }

    public static void unmap() throws RemapException {
        for (class_2960 registryId : class_2378.field_11144.method_10235()) {
            class_2385 registry = (class_2385)class_2378.field_11144.method_10223(registryId);
            if (!(registry instanceof RemappableRegistry)) continue;
            ((RemappableRegistry)registry).unmap(registryId.toString());
        }
    }
}

