/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import net.fabricmc.fabric.impl.registry.ListenableRegistry;
import net.fabricmc.fabric.impl.registry.RegistryListener;
import net.fabricmc.fabric.impl.registry.RemapException;
import net.fabricmc.fabric.impl.registry.RemappableRegistry;
import net.minecraft.class_2370;
import net.minecraft.class_2960;
import net.minecraft.class_3513;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2370.class})
public abstract class MixinIdRegistry<T>
implements RemappableRegistry,
ListenableRegistry<T>,
RegistryListener<T> {
    @Shadow
    protected static Logger field_11111;
    @Shadow
    protected class_3513<T> field_11110;
    @Shadow
    protected BiMap<class_2960, T> field_11107;
    @Shadow
    private int field_11109;
    private Object2IntMap<class_2960> fabric_prevIndexedEntries;
    private BiMap<class_2960, T> fabric_prevEntries;
    private RegistryListener[] fabric_listeners;

    @Override
    public void registerListener(RegistryListener<T> listener) {
        if (this.fabric_listeners == null) {
            this.fabric_listeners = new RegistryListener[]{listener};
        } else {
            RegistryListener[] newListeners = new RegistryListener[this.fabric_listeners.length + 1];
            System.arraycopy(this.fabric_listeners, 0, newListeners, 0, this.fabric_listeners.length);
            newListeners[this.fabric_listeners.length] = listener;
            this.fabric_listeners = newListeners;
        }
    }

    @Inject(method={"set"}, at={@At(value="HEAD")})
    public void setPre(int id, class_2960 identifier, Object object, CallbackInfoReturnable info) {
        class_2370 registry = (class_2370)this;
        if (this.fabric_listeners != null) {
            for (RegistryListener listener : this.fabric_listeners) {
                listener.beforeRegistryRegistration(registry, id, identifier, object, !this.field_11107.containsKey((Object)identifier));
            }
        }
    }

    @Inject(method={"set"}, at={@At(value="RETURN")})
    public void setPost(int id, class_2960 identifier, Object object, CallbackInfoReturnable info) {
        class_2370 registry = (class_2370)this;
        if (this.fabric_listeners != null) {
            for (RegistryListener listener : this.fabric_listeners) {
                listener.afterRegistryRegistration(registry, id, identifier, object);
            }
        }
    }

    @Override
    public void remap(String name, Object2IntMap<class_2960> remoteIndexedEntries, RemappableRegistry.RemapMode mode) throws RemapException {
        class_2370 registry = (class_2370)this;
        switch (mode) {
            case AUTHORITATIVE: {
                break;
            }
            case REMOTE: {
                Object remoteId2;
                ArrayList strings = new ArrayList();
                for (Object remoteId2 : remoteIndexedEntries.keySet()) {
                    if (registry.method_10235().contains(remoteId2)) continue;
                    strings.add(" - " + remoteId2);
                }
                if (strings.isEmpty()) break;
                StringBuilder builder = new StringBuilder("Received ID map for " + name + " contains IDs unknown to the receiver!");
                remoteId2 = strings.iterator();
                while (remoteId2.hasNext()) {
                    String s = (String)remoteId2.next();
                    builder.append('\n').append(s);
                }
                throw new RemapException(builder.toString());
            }
            case EXACT: {
                if (registry.method_10235().equals(remoteIndexedEntries.keySet())) break;
                ArrayList<String> strings = new ArrayList<String>();
                for (class_2960 remoteId : remoteIndexedEntries.keySet()) {
                    if (registry.method_10235().contains(remoteId)) continue;
                    strings.add(" - " + remoteId + " (missing on local)");
                }
                for (Object localId : registry.method_10235()) {
                    if (remoteIndexedEntries.keySet().contains(localId)) continue;
                    strings.add(" - " + localId + " (missing on remote)");
                }
                StringBuilder builder = new StringBuilder("Local and remote ID sets for " + name + " do not match!");
                for (String s : strings) {
                    builder.append('\n').append(s);
                }
                throw new RemapException(builder.toString());
            }
        }
        if (this.fabric_prevIndexedEntries == null) {
            this.fabric_prevIndexedEntries = new Object2IntOpenHashMap();
            this.fabric_prevEntries = HashBiMap.create(this.field_11107);
            for (class_2960 id : registry.method_10235()) {
                this.fabric_prevIndexedEntries.put((Object)id, registry.method_10249(registry.method_10223(id)));
            }
        }
        if (mode == RemappableRegistry.RemapMode.AUTHORITATIVE) {
            int maxValue = 0;
            Object2IntOpenHashMap oldRemoteIndexedEntries = remoteIndexedEntries;
            remoteIndexedEntries = new Object2IntOpenHashMap();
            for (class_2960 id : oldRemoteIndexedEntries.keySet()) {
                int v = oldRemoteIndexedEntries.getInt((Object)id);
                remoteIndexedEntries.put((Object)id, v);
                if (v <= maxValue) continue;
                maxValue = v;
            }
            for (class_2960 id : registry.method_10235()) {
                if (remoteIndexedEntries.containsKey((Object)id)) continue;
                field_11111.warn("Adding " + id + " to registry.");
                remoteIndexedEntries.put((Object)id, ++maxValue);
            }
        } else if (mode == RemappableRegistry.RemapMode.REMOTE) {
            HashSet<class_2960> droppedIds = new HashSet<class_2960>();
            for (class_2960 id : registry.method_10235()) {
                if (remoteIndexedEntries.containsKey((Object)id)) continue;
                droppedIds.add(id);
            }
            this.field_11107.keySet().removeAll(droppedIds);
        }
        if (this.fabric_listeners != null) {
            for (RegistryListener listener : this.fabric_listeners) {
                listener.beforeRegistryCleared(registry);
            }
        }
        this.field_11110.method_15229();
        this.field_11109 = 0;
        ArrayList<class_2960> orderedRemoteEntries = new ArrayList<class_2960>((Collection<class_2960>)remoteIndexedEntries.keySet());
        orderedRemoteEntries.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)remoteIndexedEntries).getInt(arg_0)));
        for (class_2960 identifier : orderedRemoteEntries) {
            int id = remoteIndexedEntries.getInt((Object)identifier);
            Object object = this.field_11107.get((Object)identifier);
            if (object == null) {
                if (mode != RemappableRegistry.RemapMode.AUTHORITATIVE) {
                    throw new RemapException(identifier + " missing from registry, but requested!");
                }
                field_11111.warn(identifier + " missing from registry, but requested!");
                continue;
            }
            this.field_11110.method_15230(object, id);
            if (this.field_11109 <= id) {
                this.field_11109 = id + 1;
            }
            if (this.fabric_listeners == null) continue;
            for (RegistryListener listener : this.fabric_listeners) {
                listener.beforeRegistryRegistration(registry, id, identifier, object, false);
            }
        }
    }

    @Override
    public void unmap(String name) throws RemapException {
        if (this.fabric_prevIndexedEntries != null) {
            this.field_11107.clear();
            this.field_11107.putAll(this.fabric_prevEntries);
            this.remap(name, this.fabric_prevIndexedEntries, RemappableRegistry.RemapMode.AUTHORITATIVE);
            this.fabric_prevIndexedEntries = null;
            this.fabric_prevEntries = null;
        }
    }
}

